/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.Serializable;
import org.apache.cayenne.conf.PasswordEncoding;
import org.apache.cayenne.conf.PlainTextPasswordEncoder;
import org.apache.cayenne.util.Util;

public class DataSourceInfo
implements Cloneable,
Serializable {
    protected String userName;
    protected String password;
    protected String jdbcDriver;
    protected String dataSourceUrl;
    protected String adapterClassName;
    protected int minConnections = 1;
    protected int maxConnections = 1;
    public static final String PASSWORD_LOCATION_CLASSPATH = "classpath";
    public static final String PASSWORD_LOCATION_EXECUTABLE = "executable";
    public static final String PASSWORD_LOCATION_MODEL = "model";
    public static final String PASSWORD_LOCATION_URL = "url";
    protected String passwordEncoderClass = PasswordEncoding.standardEncoders[0];
    protected String passwordEncoderKey = "";
    protected String passwordLocation = "model";
    protected String passwordSourceExecutable = "";
    protected String passwordSourceFilename = "";
    protected final String passwordSourceModel = "Not Applicable";
    protected String passwordSourceUrl = "";

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataSourceInfo dsi = (DataSourceInfo)obj;
        if (!Util.nullSafeEquals(this.userName, dsi.userName)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.password, dsi.password)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.jdbcDriver, dsi.jdbcDriver)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.dataSourceUrl, dsi.dataSourceUrl)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.adapterClassName, dsi.adapterClassName)) {
            return false;
        }
        if (this.minConnections != dsi.minConnections) {
            return false;
        }
        if (this.maxConnections != dsi.maxConnections) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordEncoderClass, dsi.passwordEncoderClass)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordEncoderKey, dsi.passwordEncoderKey)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordSourceFilename, dsi.passwordSourceFilename)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordSourceModel, dsi.passwordSourceModel)) {
            return false;
        }
        if (!Util.nullSafeEquals(this.passwordSourceUrl, dsi.passwordSourceUrl)) {
            return false;
        }
        return Util.nullSafeEquals(this.passwordLocation, dsi.passwordLocation);
    }

    public DataSourceInfo cloneInfo() {
        try {
            return (DataSourceInfo)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Cloning error", ex);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(this.getClass().getName()).append(":").append("\n   user name: ").append(this.userName).append("\n   password: ");
        buf.append("**********");
        buf.append("\n   driver: ").append(this.jdbcDriver).append("\n   db adapter class: ").append(this.adapterClassName).append("\n   url: ").append(this.dataSourceUrl).append("\n   min. connections: ").append(this.minConnections).append("\n   max. connections: ").append(this.maxConnections);
        if (!PlainTextPasswordEncoder.class.getName().equals(this.passwordEncoderClass)) {
            buf.append("\n   encoder class: ").append(this.passwordEncoderClass).append("\n   encoder key: ").append(this.passwordEncoderKey);
        }
        if (!PASSWORD_LOCATION_MODEL.equals(this.passwordLocation)) {
            buf.append("\n   password location: ").append(this.passwordLocation).append("\n   password source: ").append(this.getPasswordSource());
        }
        buf.append("\n]");
        return buf.toString();
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public void setAdapterClassName(String adapterClassName) {
        this.adapterClassName = adapterClassName;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setJdbcDriver(String jdbcDriver2) {
        this.jdbcDriver = jdbcDriver2;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setDataSourceUrl(String dataSourceUrl) {
        this.dataSourceUrl = dataSourceUrl;
    }

    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    public PasswordEncoding getPasswordEncoder() {
        PasswordEncoding encoder = null;
        try {
            encoder = (PasswordEncoding)Thread.currentThread().getContextClassLoader().loadClass(this.getPasswordEncoderClass()).newInstance();
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        return encoder;
    }

    public String getPasswordEncoderClass() {
        return this.passwordEncoderClass;
    }

    public void setPasswordEncoderClass(String passwordEncoderClass) {
        this.passwordEncoderClass = passwordEncoderClass == null ? PasswordEncoding.standardEncoders[0] : passwordEncoderClass;
    }

    public String getPasswordEncoderKey() {
        return this.passwordEncoderKey;
    }

    public void setPasswordEncoderKey(String passwordEncoderKey) {
        this.passwordEncoderKey = passwordEncoderKey;
    }

    public String getPasswordSourceFilename() {
        return this.passwordSourceFilename;
    }

    public void setPasswordSourceFilename(String passwordSourceFilename) {
        this.passwordSourceFilename = passwordSourceFilename;
    }

    public String getPasswordSourceModel() {
        return "Not Applicable";
    }

    public String getPasswordSourceUrl() {
        return this.passwordSourceUrl;
    }

    public void setPasswordSourceUrl(String passwordSourceUrl) {
        this.passwordSourceUrl = passwordSourceUrl;
    }

    public String getPasswordSourceExecutable() {
        return this.passwordSourceExecutable;
    }

    public void setPasswordSourceExecutable(String passwordSourceExecutable) {
        this.passwordSourceExecutable = passwordSourceExecutable;
    }

    public String getPasswordSource() {
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_CLASSPATH)) {
            return this.getPasswordSourceFilename();
        }
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_EXECUTABLE)) {
            return this.getPasswordSourceExecutable();
        }
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_MODEL)) {
            return this.getPasswordSourceModel();
        }
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_URL)) {
            return this.getPasswordSourceUrl();
        }
        throw new RuntimeException("Invalid password source detected");
    }

    public void setPasswordSource(String passwordSource) {
        if (this.getPasswordLocation().equals(PASSWORD_LOCATION_CLASSPATH)) {
            this.setPasswordSourceFilename(passwordSource);
        } else if (this.getPasswordLocation().equals(PASSWORD_LOCATION_EXECUTABLE)) {
            this.setPasswordSourceExecutable(passwordSource);
        } else if (this.getPasswordLocation().equals(PASSWORD_LOCATION_URL)) {
            this.setPasswordSourceUrl(passwordSource);
        }
    }

    public String getPasswordLocation() {
        return this.passwordLocation;
    }

    public void setPasswordLocation(String passwordLocation) {
        this.passwordLocation = passwordLocation == null ? PASSWORD_LOCATION_MODEL : passwordLocation;
    }
}

