/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactGenerationMode;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.ClassGeneratorResourceLoader;
import org.apache.cayenne.gen.EmbeddableArtifact;
import org.apache.cayenne.gen.EntityArtifact;
import org.apache.cayenne.gen.ImportUtils;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.tools.NamePatternMatcher;
import org.apache.commons.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.NullLogSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassGenerationAction {
    public static final String SINGLE_CLASS_TEMPLATE = "dotemplates/v1_2/singleclass.vm";
    public static final String SUBCLASS_TEMPLATE = "dotemplates/v1_2/subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "dotemplates/v1_2/superclass.vm";
    public static final String EMBEDDABLE_SINGLE_CLASS_TEMPLATE = "dotemplates/v1_2/embeddable-singleclass.vm";
    public static final String EMBEDDABLE_SUBCLASS_TEMPLATE = "dotemplates/v1_2/embeddable-subclass.vm";
    public static final String EMBEDDABLE_SUPERCLASS_TEMPLATE = "dotemplates/v1_2/embeddable-superclass.vm";
    public static final String SUPERCLASS_PREFIX = "_";
    private static final String WILDCARD = "*";
    protected Collection<Artifact> artifacts;
    protected String superPkg;
    protected DataMap dataMap;
    protected ArtifactsGenerationMode artifactsGenerationMode;
    protected boolean makePairs = true;
    protected Log logger;
    protected File destDir;
    protected boolean overwrite;
    protected boolean usePkgPath = true;
    protected String template;
    protected String superTemplate;
    protected String embeddableTemplate;
    protected String embeddableSuperTemplate;
    protected long timestamp = System.currentTimeMillis();
    protected String outputPattern = "*.java";
    protected String encoding;
    protected VelocityContext context = new VelocityContext();
    protected Map<String, Template> templateCache = new HashMap<String, Template>(5);

    public ClassGenerationAction() {
        this.artifacts = new ArrayList<Artifact>();
    }

    protected String defaultTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: {
                return SINGLE_CLASS_TEMPLATE;
            }
            case ENTITY_SUBCLASS: {
                return SUBCLASS_TEMPLATE;
            }
            case ENTITY_SUPERCLASS: {
                return SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUBCLASS: {
                return EMBEDDABLE_SUBCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUPERCLASS: {
                return EMBEDDABLE_SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SINGLE_CLASS: {
                return EMBEDDABLE_SINGLE_CLASS_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Invalid template type: " + (Object)((Object)type));
    }

    protected String customTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: {
                return this.template;
            }
            case ENTITY_SUBCLASS: {
                return this.template;
            }
            case ENTITY_SUPERCLASS: {
                return this.superTemplate;
            }
            case EMBEDDABLE_SUBCLASS: {
                return this.embeddableTemplate;
            }
            case EMBEDDABLE_SUPERCLASS: {
                return this.embeddableSuperTemplate;
            }
        }
        throw new IllegalArgumentException("Invalid template type: " + (Object)((Object)type));
    }

    protected String getSuperclassPrefix() {
        return SUPERCLASS_PREFIX;
    }

    protected void resetContextForArtifact(Artifact artifact) {
        StringUtils stringUtils = StringUtils.getInstance();
        String qualifiedClassName = artifact.getQualifiedClassName();
        String packageName = stringUtils.stripClass(qualifiedClassName);
        String className = stringUtils.stripPackageName(qualifiedClassName);
        String qualifiedBaseClassName = artifact.getQualifiedBaseClassName();
        String basePackageName = stringUtils.stripClass(qualifiedBaseClassName);
        String baseClassName = stringUtils.stripPackageName(qualifiedBaseClassName);
        String superClassName = this.getSuperclassPrefix() + stringUtils.stripPackageName(qualifiedClassName);
        String superPackageName = this.superPkg;
        if (superPackageName == null) {
            superPackageName = packageName;
        }
        this.context.put("baseClassName", baseClassName);
        this.context.put("basePackageName", basePackageName);
        this.context.put("subClassName", className);
        this.context.put("subPackageName", packageName);
        this.context.put("superClassName", superClassName);
        this.context.put("superPackageName", superPackageName);
        this.context.put("object", artifact.getObject());
        this.context.put("stringUtils", stringUtils);
    }

    protected void resetContextForArtifactTemplate(Artifact artifact, TemplateType templateType) {
        this.context.put("importUtils", new ImportUtils());
        artifact.postInitContext(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        this.validateAttributes();
        try {
            for (Artifact artifact : this.artifacts) {
                this.execute(artifact);
                if (this.artifactsGenerationMode != ArtifactsGenerationMode.SINGLE_RUN) continue;
                break;
            }
        }
        finally {
            this.templateCache.clear();
        }
    }

    protected void execute(Artifact artifact) throws Exception {
        TemplateType[] templateTypes;
        this.resetContextForArtifact(artifact);
        ArtifactGenerationMode artifactMode = this.makePairs ? ArtifactGenerationMode.GENERATION_GAP : ArtifactGenerationMode.SINGLE_CLASS;
        for (TemplateType type : templateTypes = artifact.getTemplateTypes(artifactMode)) {
            Writer out = this.openWriter(type);
            if (out == null) continue;
            this.resetContextForArtifactTemplate(artifact, type);
            this.getTemplate(type).merge(this.context, out);
            out.close();
        }
    }

    protected Template getTemplate(TemplateType type) throws Exception {
        Template template;
        String templateName = this.customTemplateName(type);
        if (templateName == null) {
            templateName = this.defaultTemplateName(type);
        }
        if ((template = this.templateCache.get(templateName)) == null) {
            Properties props = new Properties();
            props.put("runtime.log.logsystem.class", NullLogSystem.class.getName());
            props.put("resource.loader", "cayenne");
            props.put("cayenne.resource.loader.class", ClassGeneratorResourceLoader.class.getName());
            props.put("cayenne.resource.loader.cache", "false");
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.init(props);
            template = velocityEngine.getTemplate(templateName);
            this.templateCache.put(templateName, template);
        }
        return template;
    }

    protected void validateAttributes() {
        if (this.destDir == null) {
            throw new CayenneRuntimeException("'destDir' attribute is missing.");
        }
        if (!this.destDir.isDirectory()) {
            throw new CayenneRuntimeException("'destDir' is not a directory.");
        }
        if (!this.destDir.canWrite()) {
            throw new CayenneRuntimeException("Do not have write permissions for " + this.destDir);
        }
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMakePairs(boolean makePairs) {
        this.makePairs = makePairs;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSuperTemplate(String superTemplate) {
        this.superTemplate = superTemplate;
    }

    public void setUsePkgPath(boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    protected Writer openWriter(TemplateType templateType) throws Exception {
        File outFile;
        File file = outFile = templateType.isSuperclass() ? this.fileForSuperclass() : this.fileForClass();
        if (outFile == null) {
            return null;
        }
        if (this.logger != null) {
            String label = templateType.isSuperclass() ? "superclass" : "class";
            this.logger.info("Generating " + label + " file: " + outFile.getCanonicalPath());
        }
        FileOutputStream out = new FileOutputStream(outFile);
        return this.encoding != null ? new OutputStreamWriter((OutputStream)out, this.encoding) : new OutputStreamWriter(out);
    }

    protected File fileForSuperclass() throws Exception {
        String packageName = (String)this.context.get("superPackageName");
        String className = (String)this.context.get("superClassName");
        String filename = NamePatternMatcher.replaceWildcardInStringWithString(WILDCARD, this.outputPattern, className);
        File dest = new File(this.mkpath(this.destDir, packageName), filename);
        if (dest.exists() && !this.isOld(dest)) {
            if (this.superTemplate == null) {
                return null;
            }
            File superTemplateFile = new File(this.superTemplate);
            if (superTemplateFile.lastModified() < dest.lastModified()) {
                return null;
            }
        }
        return dest;
    }

    protected File fileForClass() throws Exception {
        String packageName = (String)this.context.get("subPackageName");
        String className = (String)this.context.get("subClassName");
        String filename = NamePatternMatcher.replaceWildcardInStringWithString(WILDCARD, this.outputPattern, className);
        File dest = new File(this.mkpath(this.destDir, packageName), filename);
        if (dest.exists()) {
            if (this.makePairs) {
                return null;
            }
            if (!this.overwrite) {
                return null;
            }
            if (!this.isOld(dest)) {
                if (this.template == null) {
                    return null;
                }
                File templateFile = new File(this.template);
                if (templateFile.lastModified() < dest.lastModified()) {
                    return null;
                }
            }
        }
        return dest;
    }

    protected boolean isOld(File file) {
        return file.lastModified() <= this.timestamp;
    }

    protected File mkpath(File dest, String pkgName) throws Exception {
        if (!this.usePkgPath || pkgName == null) {
            return dest;
        }
        String path = pkgName.replace('.', File.separatorChar);
        File fullPath = new File(dest, path);
        if (!fullPath.isDirectory() && !fullPath.mkdirs()) {
            throw new Exception("Error making path: " + fullPath);
        }
        return fullPath;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public void addEntities(Collection<ObjEntity> entities) {
        if (entities != null) {
            for (ObjEntity entity : entities) {
                this.artifacts.add(new EntityArtifact(entity));
            }
        }
    }

    public void addEmbeddables(Collection<Embeddable> embeddables) {
        if (embeddables != null) {
            for (Embeddable embeddable : embeddables) {
                this.artifacts.add(new EmbeddableArtifact(embeddable));
            }
        }
    }

    public void setContext(VelocityContext context) {
        this.context = context;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setEmbeddableTemplate(String embeddableTemplate) {
        this.embeddableTemplate = embeddableTemplate;
    }

    public void setEmbeddableSuperTemplate(String embeddableSuperTemplate) {
        this.embeddableSuperTemplate = embeddableSuperTemplate;
    }

    public void setArtifactsGenerationMode(String mode) {
        this.artifactsGenerationMode = ArtifactsGenerationMode.RUN_PER_ARTIFACT.getLabel().equalsIgnoreCase(mode) ? ArtifactsGenerationMode.RUN_PER_ARTIFACT : ArtifactsGenerationMode.SINGLE_RUN;
    }
}

