/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.ArrayList;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropColumnToModel
extends AbstractToModelToken.EntityAndColumn {
    public DropColumnToModel(DbEntity entity, DbAttribute column) {
        super(entity, column);
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddColumnToDb(this.getEntity(), this.getColumn());
    }

    public void execute(MergerContext mergerContext) {
        ArrayList<DbRelationship> dbRelationships = new ArrayList<DbRelationship>(this.getEntity().getRelationships());
        for (DbRelationship dbRelationship : dbRelationships) {
            for (DbJoin join : dbRelationship.getJoins()) {
                if (join.getSource() != this.getColumn() && join.getTarget() != this.getColumn()) continue;
                this.remove(dbRelationship, true);
            }
        }
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(this.getEntity())) {
            ObjAttribute objAttribute = objEntity.getAttributeForDbAttribute(this.getColumn());
            if (objAttribute == null) continue;
            objEntity.removeAttribute(objAttribute.getName());
        }
        this.getEntity().removeAttribute(this.getColumn().getName());
    }

    public String getTokenName() {
        return "Drop Column";
    }
}

