/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.cayenne.modeler.ActionManager;
import org.apache.cayenne.modeler.action.AboutAction;
import org.apache.cayenne.modeler.action.ConfigurePreferencesAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateDomainAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.DocumentationAction;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.action.GenerateCodeAction;
import org.apache.cayenne.modeler.action.GenerateDBAction;
import org.apache.cayenne.modeler.action.ImportDBAction;
import org.apache.cayenne.modeler.action.ImportDataMapAction;
import org.apache.cayenne.modeler.action.ImportEOModelAction;
import org.apache.cayenne.modeler.action.MigrateAction;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.OperatingSystem;
import org.apache.cayenne.modeler.util.RecentFileMenu;

public class CayenneModelerFrame
extends JFrame
implements DataNodeDisplayListener,
DataMapDisplayListener,
ObjEntityDisplayListener,
DbEntityDisplayListener,
QueryDisplayListener,
ProcedureDisplayListener {
    protected EditorView view;
    protected RecentFileMenu recentFileMenu;
    protected ActionManager actionManager;
    protected JLabel status;

    public CayenneModelerFrame(ActionManager actionManager) {
        super("CayenneModeler");
        this.actionManager = actionManager;
        this.initMenus();
        this.initToolbar();
        this.initStatusBar();
    }

    private CayenneAction getAction(String key) {
        return this.actionManager.getAction(key);
    }

    protected void initMenus() {
        this.getContentPane().setLayout(new BorderLayout());
        JMenu fileMenu = new JMenu("File");
        JMenu projectMenu = new JMenu("Project");
        JMenu toolMenu = new JMenu("Tools");
        JMenu helpMenu = new JMenu("Help");
        if (OperatingSystem.getOS() != OperatingSystem.MAC_OS_X) {
            fileMenu.setMnemonic(70);
            projectMenu.setMnemonic(80);
            toolMenu.setMnemonic(84);
            helpMenu.setMnemonic(72);
        }
        fileMenu.add(this.getAction(NewProjectAction.getActionName()).buildMenu());
        fileMenu.add(this.getAction(OpenProjectAction.getActionName()).buildMenu());
        fileMenu.add(this.getAction(ProjectAction.getActionName()).buildMenu());
        fileMenu.add(this.getAction(ImportDataMapAction.getActionName()).buildMenu());
        fileMenu.addSeparator();
        fileMenu.add(this.getAction(SaveAction.getActionName()).buildMenu());
        fileMenu.add(this.getAction(SaveAsAction.getActionName()).buildMenu());
        fileMenu.add(this.getAction(RevertAction.getActionName()).buildMenu());
        fileMenu.addSeparator();
        this.recentFileMenu = new RecentFileMenu("Recent Projects");
        this.recentFileMenu.rebuildFromPreferences();
        this.recentFileMenu.setEnabled(this.recentFileMenu.getMenuComponentCount() > 0);
        fileMenu.add(this.recentFileMenu);
        if (OperatingSystem.getOS() != OperatingSystem.MAC_OS_X) {
            fileMenu.addSeparator();
            fileMenu.add(this.getAction(ExitAction.getActionName()).buildMenu());
        }
        projectMenu.add(this.getAction(ValidateAction.getActionName()).buildMenu());
        projectMenu.addSeparator();
        projectMenu.add(this.getAction(CreateDomainAction.getActionName()).buildMenu());
        projectMenu.add(this.getAction(CreateNodeAction.getActionName()).buildMenu());
        projectMenu.add(this.getAction(CreateDataMapAction.getActionName()).buildMenu());
        projectMenu.add(this.getAction(CreateObjEntityAction.getActionName()).buildMenu());
        projectMenu.add(this.getAction(CreateDbEntityAction.getActionName()).buildMenu());
        projectMenu.add(this.getAction(CreateProcedureAction.getActionName()).buildMenu());
        projectMenu.add(this.getAction(CreateQueryAction.getActionName()).buildMenu());
        projectMenu.addSeparator();
        projectMenu.add(this.getAction(ObjEntitySyncAction.getActionName()).buildMenu());
        projectMenu.addSeparator();
        projectMenu.add(this.getAction(RemoveAction.getActionName()).buildMenu());
        toolMenu.add(this.getAction(ImportDBAction.getActionName()).buildMenu());
        toolMenu.add(this.getAction(ImportEOModelAction.getActionName()).buildMenu());
        toolMenu.addSeparator();
        toolMenu.add(this.getAction(GenerateCodeAction.getActionName()).buildMenu());
        toolMenu.add(this.getAction(GenerateDBAction.getActionName()).buildMenu());
        toolMenu.add(this.getAction(MigrateAction.getActionName()).buildMenu());
        if (OperatingSystem.getOS() != OperatingSystem.MAC_OS_X) {
            toolMenu.addSeparator();
            toolMenu.add(this.getAction(ConfigurePreferencesAction.getActionName()).buildMenu());
        }
        if (OperatingSystem.getOS() != OperatingSystem.MAC_OS_X) {
            helpMenu.add(this.getAction(AboutAction.getActionName()).buildMenu());
        }
        helpMenu.add(this.getAction(DocumentationAction.getActionName()).buildMenu());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(projectMenu);
        menuBar.add(toolMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    protected void initStatusBar() {
        this.status = new JLabel();
        this.status.setFont(this.status.getFont().deriveFont(0, 10.0f));
        JPanel statusBar = new JPanel(new FlowLayout(0, 3, 1));
        statusBar.add(Box.createVerticalStrut(16));
        statusBar.add(this.status);
        this.getContentPane().add((Component)statusBar, "South");
    }

    protected void initToolbar() {
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.getAction(NewProjectAction.getActionName()).buildButton());
        toolBar.add(this.getAction(OpenProjectAction.getActionName()).buildButton());
        toolBar.add(this.getAction(SaveAction.getActionName()).buildButton());
        toolBar.add(this.getAction(RemoveAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(this.getAction(CreateDomainAction.getActionName()).buildButton());
        toolBar.add(this.getAction(CreateNodeAction.getActionName()).buildButton());
        toolBar.add(this.getAction(CreateDataMapAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(this.getAction(CreateDbEntityAction.getActionName()).buildButton());
        toolBar.add(this.getAction(CreateProcedureAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(this.getAction(CreateObjEntityAction.getActionName()).buildButton());
        toolBar.add(this.getAction(CreateQueryAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(this.getAction(NavigateBackwardAction.getActionName()).buildButton());
        toolBar.add(this.getAction(NavigateForwardAction.getActionName()).buildButton());
        JPanel east = new JPanel(new BorderLayout());
        final JTextField findField = new JTextField(10);
        findField.setAction(this.getAction(FindAction.getActionName()));
        JLabel findLabel = new JLabel("Search:");
        findLabel.setLabelFor(findField);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if (event instanceof KeyEvent && ((KeyEvent)event).getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() && ((KeyEvent)event).getKeyCode() == 70) {
                    findField.requestFocus();
                }
            }
        }, 8L);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        box.add(findLabel);
        box.add(findField);
        east.add((Component)box, "East");
        toolBar.add(east);
        this.getContentPane().add((Component)toolBar, "North");
    }

    public void currentDataNodeChanged(DataNodeDisplayEvent e) {
        this.actionManager.dataNodeSelected();
    }

    public void currentDataMapChanged(DataMapDisplayEvent e) {
        this.actionManager.dataMapSelected();
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        this.actionManager.objEntitySelected();
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        this.actionManager.dbEntitySelected();
    }

    public void currentQueryChanged(QueryDisplayEvent e) {
        this.actionManager.querySelected();
    }

    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        this.actionManager.procedureSelected();
    }

    public EditorView getView() {
        return this.view;
    }

    public JLabel getStatus() {
        return this.status;
    }

    public RecentFileMenu getRecentFileMenu() {
        return this.recentFileMenu;
    }

    public void setView(EditorView view) {
        boolean change = false;
        if (this.view != null) {
            this.getContentPane().remove(this.view);
            change = true;
        }
        this.view = view;
        if (view != null) {
            this.getContentPane().add((Component)view, "Center");
            change = true;
        }
        if (change) {
            this.validate();
        }
    }
}

