/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;

public abstract class AbstractRemoveCallbackMethodAction
extends RemoveAction {
    public AbstractRemoveCallbackMethodAction(String actionName, Application application) {
        super(actionName, application);
    }

    public abstract CallbackMap getCallbackMap();

    public String getIconName() {
        return "icon-remove-method.gif";
    }

    public final void performAction(ActionEvent e) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog();
        if (this.getProjectController().getCurrentCallbackMethod() != null && dialog.shouldDelete("callback method", this.getProjectController().getCurrentCallbackMethod())) {
            this.removeCallbackMethod(e);
        }
    }

    private void removeCallbackMethod(ActionEvent actionEvent) {
        ProjectController mediator = this.getProjectController();
        CallbackType callbackType = mediator.getCurrentCallbackType();
        String callbackMethod = mediator.getCurrentCallbackMethod();
        this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).removeCallbackMethod(callbackMethod);
        CallbackMethodEvent e = new CallbackMethodEvent(actionEvent.getSource(), null, callbackMethod, 3);
        mediator.fireCallbackMethodEvent(e);
    }
}

