/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.cayenne.util.NameConverter;

public class CreateObjEntityAction
extends CayenneAction {
    public static String getActionName() {
        return "Create ObjEntity";
    }

    public CreateObjEntityAction(Application application) {
        super(CreateObjEntityAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-new_objentity.gif";
    }

    public void performAction(ActionEvent e) {
        this.createObjEntity();
    }

    protected void createObjEntity() {
        String pkg;
        ProjectController mediator = this.getProjectController();
        DataMap dataMap = mediator.getCurrentDataMap();
        ObjEntity entity = (ObjEntity)NamedObjectFactory.createObject(ObjEntity.class, mediator.getCurrentDataMap());
        entity.setSuperClassName(dataMap.getDefaultSuperclass());
        entity.setDeclaredLockType(dataMap.getDefaultLockType());
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity != null) {
            entity.setDbEntity(dbEntity);
            String baseName = NameConverter.underscoredToJava(dbEntity.getName(), true);
            String entityName = NamedObjectFactory.createName(ObjEntity.class, dbEntity.getDataMap(), baseName);
            entity.setName(entityName);
        }
        if ((pkg = dataMap.getDefaultPackage()) != null) {
            if (!pkg.endsWith(".")) {
                pkg = pkg + ".";
            }
            entity.setClassName(pkg + entity.getName());
        }
        if (dataMap.isClientSupported()) {
            String clientPkg = dataMap.getDefaultClientPackage();
            if (clientPkg != null) {
                if (!clientPkg.endsWith(".")) {
                    clientPkg = clientPkg + ".";
                }
                entity.setClientClassName(clientPkg + entity.getName());
            }
            entity.setClientSuperClassName(dataMap.getDefaultClientSuperclass());
        }
        dataMap.addObjEntity(entity);
        EntityMergeSupport merger = new EntityMergeSupport(dataMap);
        merger.synchronizeWithDbEntity(entity);
        mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 2));
        EntityDisplayEvent displayEvent = new EntityDisplayEvent(this, entity, dataMap, mediator.getCurrentDataNode(), mediator.getCurrentDataDomain());
        displayEvent.setMainTabFocus(true);
        mediator.fireObjEntityDisplayEvent(displayEvent);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataMap.class) != null;
    }
}

