/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.event.ProcedureParameterEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;

public class CreateProcedureParameterAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Parameter";
    }

    public CreateProcedureParameterAction(Application application) {
        super(CreateProcedureParameterAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-plus.gif";
    }

    public void performAction(ActionEvent e) {
        if (this.getProjectController().getCurrentProcedure() != null) {
            this.createProcedureParameter();
        }
    }

    public void createProcedureParameter() {
        Procedure procedure = this.getProjectController().getCurrentProcedure();
        ProcedureParameter parameter = (ProcedureParameter)NamedObjectFactory.createObject(ProcedureParameter.class, procedure);
        procedure.addCallParameter(parameter);
        ProjectController mediator = this.getProjectController();
        mediator.fireProcedureParameterEvent(new ProcedureParameterEvent((Object)this, parameter, 2));
        mediator.fireProcedureParameterDisplayEvent(new ProcedureParameterDisplayEvent(this, parameter, procedure, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain()));
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(Procedure.class) != null;
    }
}

