/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;

public class CreateRelationshipAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Relationship";
    }

    public CreateRelationshipAction(Application application) {
        super(CreateRelationshipAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-relationship.gif";
    }

    public void performAction(ActionEvent e) {
        ObjEntity objEnt = this.getProjectController().getCurrentObjEntity();
        if (objEnt != null) {
            this.createObjRelationship(objEnt);
        } else {
            DbEntity dbEnt = this.getProjectController().getCurrentDbEntity();
            if (dbEnt != null) {
                this.createDbRelationship(dbEnt);
            }
        }
    }

    public void createObjRelationship(ObjEntity objEnt) {
        ProjectController mediator = this.getProjectController();
        ObjRelationship rel = (ObjRelationship)NamedObjectFactory.createObject(ObjRelationship.class, objEnt);
        rel.setSourceEntity(objEnt);
        objEnt.addRelationship(rel);
        mediator.fireObjRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)rel, (Entity)objEnt, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent((Object)this, rel, objEnt, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain());
        mediator.fireObjRelationshipDisplayEvent(rde);
    }

    public void createDbRelationship(DbEntity dbEnt) {
        ProjectController mediator = this.getProjectController();
        DbRelationship rel = (DbRelationship)NamedObjectFactory.createObject(DbRelationship.class, dbEnt);
        rel.setSourceEntity(dbEnt);
        dbEnt.addRelationship(rel);
        mediator.fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)rel, (Entity)dbEnt, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent((Object)this, rel, dbEnt, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain());
        mediator.fireDbRelationshipDisplayEvent(rde);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(Entity.class) != null;
    }
}

