/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;

public class RemoveAction
extends CayenneAction {
    public static String getActionName() {
        return "Remove";
    }

    public RemoveAction(Application application) {
        super(RemoveAction.getActionName(), application);
    }

    protected RemoveAction(String actionName, Application application) {
        super(actionName, application);
    }

    public String getIconName() {
        return "icon-trash.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public ConfirmRemoveDialog getConfirmDeleteDialog() {
        return new ConfirmRemoveDialog();
    }

    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog();
        if (mediator.getCurrentObjEntity() != null) {
            if (dialog.shouldDelete("ObjEntity", mediator.getCurrentObjEntity().getName())) {
                this.removeObjEntity();
            }
        } else if (mediator.getCurrentDbEntity() != null) {
            if (dialog.shouldDelete("DbEntity", mediator.getCurrentDbEntity().getName())) {
                this.removeDbEntity();
            }
        } else if (mediator.getCurrentQuery() != null) {
            if (dialog.shouldDelete("query", mediator.getCurrentQuery().getName())) {
                this.removeQuery();
            }
        } else if (mediator.getCurrentProcedure() != null) {
            if (dialog.shouldDelete("procedure", mediator.getCurrentProcedure().getName())) {
                this.removeProcedure();
            }
        } else if (mediator.getCurrentDataMap() != null) {
            if (dialog.shouldDelete("data map", mediator.getCurrentDataMap().getName())) {
                if (mediator.getCurrentDataNode() != null) {
                    this.removeDataMapFromDataNode();
                } else {
                    this.removeDataMap();
                }
            }
        } else if (mediator.getCurrentDataNode() != null) {
            if (dialog.shouldDelete("data node", mediator.getCurrentDataNode().getName())) {
                this.removeDataNode();
            }
        } else if (mediator.getCurrentDataDomain() != null && dialog.shouldDelete("data domain", mediator.getCurrentDataDomain().getName())) {
            this.removeDomain();
        }
    }

    protected void removeDomain() {
        ApplicationProject project = (ApplicationProject)this.getCurrentProject();
        ProjectController mediator = this.getProjectController();
        DataDomain domain = mediator.getCurrentDataDomain();
        project.getConfiguration().removeDomain(domain.getName());
        mediator.fireDomainEvent(new DomainEvent((Object)Application.getFrame(), domain, 3));
    }

    protected void removeDataMap() {
        ProjectController mediator = this.getProjectController();
        DataMap map = mediator.getCurrentDataMap();
        DataDomain domain = mediator.getCurrentDataDomain();
        domain.removeMap(map.getName());
        mediator.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), map, 3));
    }

    protected void removeDataNode() {
        ProjectController mediator = this.getProjectController();
        DataNode node = mediator.getCurrentDataNode();
        DataDomain domain = mediator.getCurrentDataDomain();
        domain.removeDataNode(node.getName());
        mediator.fireDataNodeEvent(new DataNodeEvent((Object)Application.getFrame(), node, 3));
    }

    protected void removeDbEntity() {
        ProjectController mediator = this.getProjectController();
        DbEntity ent = mediator.getCurrentDbEntity();
        DataMap map = mediator.getCurrentDataMap();
        map.removeDbEntity(ent.getName(), true);
        mediator.fireDbEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)ent, 3));
    }

    protected void removeQuery() {
        ProjectController mediator = this.getProjectController();
        Query query = mediator.getCurrentQuery();
        DataMap map = mediator.getCurrentDataMap();
        map.removeQuery(query.getName());
        mediator.fireQueryEvent(new QueryEvent((Object)Application.getFrame(), query, 3));
    }

    protected void removeProcedure() {
        ProjectController mediator = this.getProjectController();
        Procedure procedure = mediator.getCurrentProcedure();
        DataMap map = mediator.getCurrentDataMap();
        map.removeProcedure(procedure.getName());
        mediator.fireProcedureEvent(new ProcedureEvent((Object)Application.getFrame(), procedure, 3));
    }

    protected void removeObjEntity() {
        ProjectController mediator = this.getProjectController();
        ObjEntity entity = mediator.getCurrentObjEntity();
        DataMap map = mediator.getCurrentDataMap();
        map.removeObjEntity(entity.getName(), true);
        mediator.fireObjEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3));
        for (AbstractQuery abstractQuery : new ArrayList<Query>(map.getQueries())) {
            Object root = abstractQuery.getRoot();
            if (root != entity && (!(root instanceof String) || !root.toString().equals(entity.getName()))) continue;
            map.removeQuery(abstractQuery.getName());
            mediator.fireQueryEvent(new QueryEvent((Object)Application.getFrame(), (Query)abstractQuery, 3));
        }
    }

    protected void removeDataMapFromDataNode() {
        ProjectController mediator = this.getProjectController();
        DataNode node = mediator.getCurrentDataNode();
        DataMap map = mediator.getCurrentDataMap();
        node.removeDataMap(map.getName());
        mediator.fireDataNodeEvent(new DataNodeEvent((Object)Application.getFrame(), node));
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        Object lastObject = path.getObject();
        if (lastObject instanceof DataDomain) {
            return true;
        }
        if (lastObject instanceof DataMap) {
            return true;
        }
        if (lastObject instanceof DataNode) {
            return true;
        }
        if (lastObject instanceof Entity) {
            return true;
        }
        if (lastObject instanceof Attribute) {
            return true;
        }
        if (lastObject instanceof Relationship) {
            return true;
        }
        if (lastObject instanceof Procedure) {
            return true;
        }
        return lastObject instanceof ProcedureParameter;
    }
}

