/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.event.ProcedureParameterEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.project.ProjectPath;

public class RemoveProcedureParameterAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove Parameter";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public RemoveProcedureParameterAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.getObject() instanceof ProcedureParameter;
    }

    public void performAction(ActionEvent e) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog();
        if (this.getProjectController().getCurrentProcedureParameter() != null && dialog.shouldDelete("procedure parameter", this.getProjectController().getCurrentProcedureParameter().getName())) {
            this.removeProcedureParameter();
        }
    }

    protected void removeProcedureParameter() {
        ProjectController mediator = this.getProjectController();
        ProcedureParameter parameter = mediator.getCurrentProcedureParameter();
        mediator.getCurrentProcedure().removeCallParameter(parameter.getName());
        ProcedureParameterEvent e = new ProcedureParameterEvent((Object)Application.getFrame(), parameter, 3);
        mediator.fireProcedureParameterEvent(e);
    }
}

