/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.ProjectPath;

public class RemoveRelationshipAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove Relationship";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public RemoveRelationshipAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.getObject() instanceof Relationship;
    }

    public void performAction(ActionEvent e) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog();
        if (this.getProjectController().getCurrentObjRelationship() != null) {
            if (dialog.shouldDelete("ObjRelationship", this.getProjectController().getCurrentObjRelationship().getName())) {
                this.removeObjRelationship();
            }
        } else if (this.getProjectController().getCurrentDbRelationship() != null && dialog.shouldDelete("DbRelationship", this.getProjectController().getCurrentDbRelationship().getName())) {
            this.removeDbRelationship();
        }
    }

    protected void removeObjRelationship() {
        ProjectController mediator = this.getProjectController();
        ObjEntity entity = mediator.getCurrentObjEntity();
        ObjRelationship rel = mediator.getCurrentObjRelationship();
        entity.removeRelationship(rel.getName());
        RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rel, (Entity)entity, 3);
        mediator.fireObjRelationshipEvent(e);
    }

    protected void removeDbRelationship() {
        ProjectController mediator = this.getProjectController();
        DbEntity entity = mediator.getCurrentDbEntity();
        DbRelationship rel = mediator.getCurrentDbRelationship();
        entity.removeRelationship(rel.getName());
        ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
        RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rel, (Entity)entity, 3);
        mediator.fireDbRelationshipEvent(e);
    }
}

