/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorDialog;
import org.apache.cayenne.modeler.dialog.codegen.EntitiesTabController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorTabController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

public class CodeGeneratorController
extends CodeGeneratorControllerBase {
    protected CodeGeneratorDialog view;
    protected EntitiesTabController entitySelector = new EntitiesTabController(this);
    protected GeneratorTabController generatorSelector = new GeneratorTabController(this);

    public CodeGeneratorController(CayenneController parent, DataMap dataMap) {
        super(parent, dataMap);
    }

    public Component getView() {
        return this.view;
    }

    public void startup() {
        this.view = new CodeGeneratorDialog(this.generatorSelector.getView(), this.entitySelector.getView());
        this.initBindings();
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.show();
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getGenerateButton(), "generateAction()");
        builder.bindToAction(this, "entitySelectedAction()", "selected");
        builder.bindToAction(this.generatorSelector, "generatorSelectedAction()", "generator");
        this.generatorSelectedAction();
    }

    public void generatorSelectedAction() {
        GeneratorController controller = this.generatorSelector.getGeneratorController();
        this.validate(controller);
        Predicate predicate = controller != null ? controller.getDefaultEntityFilter() : PredicateUtils.falsePredicate();
        this.updateSelection(predicate);
        this.entitySelector.entitySelectedAction();
    }

    public void entitySelectedAction() {
        int size = this.getSelectedEntitiesSize();
        String label = size == 0 ? "No entities selected" : (size == 1 ? "One entity selected" : size + " entities selected");
        this.view.getEntityCount().setText(label);
    }

    public void cancelAction() {
        this.view.dispose();
    }

    public void generateAction() {
        ClassGenerationAction generator = this.generatorSelector.getGenerator();
        if (generator != null) {
            try {
                generator.execute();
                JOptionPane.showMessageDialog(this.getView(), "Class generation finished");
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.getView(), "Error generating classes - " + e.getMessage());
            }
        }
        this.view.dispose();
    }
}

