/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CodeValidationUtil;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

public abstract class GeneratorController
extends CayenneController {
    protected DataMapDefaults preferences;

    public GeneratorController(CodeGeneratorControllerBase parent) {
        super(parent);
        this.createDefaults();
        this.createView();
        this.initBindings(new BindingBuilder(this.getApplication().getBindingFactory(), this));
    }

    protected void initBindings(BindingBuilder bindingBuilder) {
        if (this.preferences.getOutputPath() == null) {
            FSPath lastPath = Application.getInstance().getFrameController().getLastDirectory();
            File lastDir = lastPath != null ? lastPath.getExistingDirectory(false) : null;
            this.preferences.setOutputPath(lastDir != null ? lastDir.getAbsolutePath() : null);
        }
        JTextField outputFolder = ((GeneratorControllerPanel)this.getView()).getOutputFolder();
        JButton outputSelect = ((GeneratorControllerPanel)this.getView()).getSelectOutputFolder();
        outputFolder.setText(this.preferences.getOutputPath());
        bindingBuilder.bindToAction(outputSelect, "selectOutputFolderAction()");
    }

    protected CodeGeneratorControllerBase getParentController() {
        return (CodeGeneratorControllerBase)this.getParent();
    }

    protected abstract GeneratorControllerPanel createView();

    protected abstract DataMapDefaults createDefaults();

    protected abstract ClassGenerationAction newGenerator();

    public ClassGenerationAction createGenerator() {
        File outputDir = this.getOutputDir();
        if (outputDir == null) {
            JOptionPane.showMessageDialog(this.getView(), "Select directory for source files.");
            return null;
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            JOptionPane.showMessageDialog(this.getView(), "Can't create directory " + outputDir + ". Select a different one.");
            return null;
        }
        if (!outputDir.isDirectory()) {
            JOptionPane.showMessageDialog(this.getView(), outputDir + " is not a valid directory.");
            return null;
        }
        ArrayList<ObjEntity> entities = new ArrayList<ObjEntity>(this.getParentController().getSelectedEntities());
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            if (!((ObjEntity)it.next()).isGeneric()) continue;
            it.remove();
        }
        ClassGenerationAction generator = this.newGenerator();
        generator.setDataMap(this.getParentController().getDataMap());
        generator.addEntities(entities);
        generator.addEmbeddables(this.getParentController().getSelectedEmbeddables());
        Domain generatorPrefs = Application.getInstance().getPreferenceDomain().getSubdomain(ClassGenerationAction.class);
        PreferenceDetail detail = generatorPrefs.getDetail("encoding", false);
        if (detail != null) {
            generator.setEncoding(detail.getProperty("encoding"));
        }
        generator.setDestDir(outputDir);
        generator.setMakePairs(true);
        String superPackage = ((GeneratorControllerPanel)this.getView()).getSuperclassPackage().getText();
        if (!Util.isEmptyString(superPackage)) {
            generator.setSuperPkg(superPackage);
        }
        return generator;
    }

    public void validateEntity(ValidationResult validationBuffer, ObjEntity entity, boolean clientValidation) {
        ValidationFailure entityFailure = this.validateEntity(clientValidation ? entity.getClientEntity() : entity);
        if (entityFailure != null) {
            validationBuffer.addFailure(entityFailure);
            return;
        }
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (attribute instanceof EmbeddedAttribute) {
                EmbeddedAttribute embeddedAttribute = (EmbeddedAttribute)attribute;
                for (ObjAttribute subAttribute : embeddedAttribute.getAttributes()) {
                    ValidationFailure failure = this.validateAttribute(subAttribute);
                    if (failure == null) continue;
                    validationBuffer.addFailure(failure);
                    return;
                }
                continue;
            }
            ValidationFailure failure = this.validateAttribute(attribute);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
        Iterator<ObjRelationship> it = entity.getRelationships().iterator();
        while (it.hasNext()) {
            ValidationFailure failure = this.validateRelationship(it.next(), clientValidation);
            if (failure == null) continue;
            validationBuffer.addFailure(failure);
            return;
        }
    }

    protected ValidationFailure validateEntity(ObjEntity entity) {
        ValidationFailure badSuperClass;
        String name = entity.getName();
        if (entity.isGeneric()) {
            return new SimpleValidationFailure(name, "Generic class");
        }
        ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "className", entity.getClassName());
        if (emptyClass != null) {
            return emptyClass;
        }
        ValidationFailure badClass = BeanValidationFailure.validateJavaClassName(name, "className", entity.getClassName());
        if (badClass != null) {
            return badClass;
        }
        if (entity.getSuperClassName() != null && (badSuperClass = BeanValidationFailure.validateJavaClassName(name, "superClassName", entity.getSuperClassName())) != null) {
            return badSuperClass;
        }
        return null;
    }

    protected ValidationFailure validateAttribute(ObjAttribute attribute) {
        String name = attribute.getEntity().getName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, "attribute.name", attribute.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "attribute.name", attribute.getName());
        if (badName != null) {
            return badName;
        }
        ValidationFailure emptyType = BeanValidationFailure.validateNotEmpty((Object)name, "attribute.type", attribute.getType());
        if (emptyType != null) {
            return emptyType;
        }
        ValidationFailure badType = BeanValidationFailure.validateJavaClassName(name, "attribute.type", attribute.getType());
        if (badType != null) {
            return badType;
        }
        return null;
    }

    protected ValidationFailure validateRelationship(ObjRelationship relationship, boolean clientValidation) {
        String name = relationship.getSourceEntity().getName();
        ValidationFailure emptyName = BeanValidationFailure.validateNotEmpty((Object)name, "relationship.name", relationship.getName());
        if (emptyName != null) {
            return emptyName;
        }
        ValidationFailure badName = CodeValidationUtil.validateJavaIdentifier(name, "relationship.name", relationship.getName());
        if (badName != null) {
            return badName;
        }
        if (!relationship.isToMany()) {
            ObjEntity targetEntity = (ObjEntity)relationship.getTargetEntity();
            if (clientValidation && targetEntity != null) {
                targetEntity = targetEntity.getClientEntity();
            }
            if (targetEntity == null) {
                return new BeanValidationFailure(name, "relationship.targetEntity", "No target entity");
            }
            if (!targetEntity.isGeneric()) {
                ValidationFailure emptyClass = BeanValidationFailure.validateNotEmpty((Object)name, "relationship.targetEntity.className", targetEntity.getClassName());
                if (emptyClass != null) {
                    return emptyClass;
                }
                ValidationFailure badClass = BeanValidationFailure.validateJavaClassName(name, "relationship.targetEntity.className", targetEntity.getClassName());
                if (badClass != null) {
                    return badClass;
                }
            }
        }
        return null;
    }

    public Predicate getDefaultEntityFilter() {
        final ObjEntity selectedEntity = Application.getInstance().getFrameController().getProjectController().getCurrentObjEntity();
        if (selectedEntity != null) {
            final boolean hasProblem = this.getParentController().getProblem(selectedEntity.getName()) != null;
            return new Predicate(){

                public boolean evaluate(Object object) {
                    return !hasProblem && object == selectedEntity;
                }
            };
        }
        return new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof ObjEntity) {
                    return GeneratorController.this.getParentController().getProblem(((ObjEntity)object).getName()) == null;
                }
                return false;
            }
        };
    }

    public File getOutputDir() {
        String dir = ((GeneratorControllerPanel)this.getView()).getOutputFolder().getText();
        return dir != null ? new File(dir) : new File(System.getProperty("user.dir"));
    }

    public DataMapDefaults getPreferences() {
        return this.preferences;
    }

    public void selectOutputFolderAction() {
        JTextField outputFolder = ((GeneratorControllerPanel)this.getView()).getOutputFolder();
        String currentDir = outputFolder.getText();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(0);
        if (!Util.isEmptyString(currentDir)) {
            chooser.setCurrentDirectory(new File(currentDir));
        } else {
            FSPath lastDir = Application.getInstance().getFrameController().getLastDirectory();
            lastDir.updateChooser(chooser);
        }
        int result = chooser.showOpenDialog(this.getView());
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            String path = selected.getAbsolutePath();
            outputFolder.setText(path);
            this.preferences.setOutputPath(path);
        }
    }
}

