/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datadomain;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncConfigDialog;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncConfigModel;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncTypesModel;
import org.apache.cayenne.modeler.dialog.datadomain.CustomRemoteEventsConfigPanel;
import org.apache.cayenne.modeler.dialog.datadomain.JGroupsConfigModel;
import org.apache.cayenne.modeler.dialog.datadomain.JGroupsConfigPanel;
import org.apache.cayenne.modeler.dialog.datadomain.JMSConfigModel;
import org.apache.cayenne.modeler.dialog.datadomain.JMSConfigPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.controller.basic.BasicController;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;
import org.scopemvc.core.ModelChangeEvent;
import org.scopemvc.core.ModelChangeListener;
import org.scopemvc.core.Selector;
import org.scopemvc.view.swing.SPanel;

public class CacheSyncConfigController
extends BasicController
implements ModelChangeListener {
    private static Log logObj = LogFactory.getLog(CacheSyncConfigController.class);
    private static final String JGROUPS_FACTORY_CLASS = "org.apache.cayenne.event.JavaGroupsBridgeFactory";
    private static final String JMS_FACTORY_CLASS = "org.apache.cayenne.event.JMSBridgeFactory";
    public static final String SAVE_CONFIG_CONTROL = "cayenne.modeler.cacheSyncConfig.save.button";
    public static final String CANCEL_CONFIG_CONTROL = "cayenne.modeler.cacheSyncConfig.cancel.button";
    public static final String JGROUPS_DEFAULT_CONTROL = "cayenne.modeler.jgroupConfig.radio1";
    public static final String JGROUPS_URL_CONTROL = "cayenne.modeler.jgroupConfig.radio2";
    protected Map existingCards;
    protected boolean modified;
    protected ProjectController eventController;

    public CacheSyncConfigController(ProjectController eventController) {
        this.eventController = eventController;
    }

    public void startup() {
        DataDomain domain = this.eventController.getCurrentDataDomain();
        String factory = (String)domain.getProperties().get("cayenne.DataRowStore.EventBridge.factory");
        CacheSyncTypesModel topModel = this.buildTypesModel(factory);
        this.setModel(topModel);
        this.setView(new CacheSyncConfigDialog());
        this.prepareChildren(factory);
        super.startup();
    }

    public void modelChanged(ModelChangeEvent inEvent) {
        logObj.info("ModelChangeEvent: " + inEvent.getSelector());
        Selector selector = inEvent.getSelector();
        if (selector.startsWith(CacheSyncTypesModel.FACTORY_LABEL_SELECTOR)) {
            this.changeConfigView();
            this.modified = true;
            logObj.info("** Factory selection modified..");
        } else {
            this.modified = true;
            logObj.info("** Property modified modified..");
        }
    }

    protected void doHandleControl(Control control) throws ControlException {
        logObj.info("Control: " + control);
        if (control.matchesID(CANCEL_CONFIG_CONTROL)) {
            this.shutdown();
        } else if (control.matchesID(SAVE_CONFIG_CONTROL)) {
            this.commitChanges();
        } else if (control.matchesID(JGROUPS_DEFAULT_CONTROL)) {
            this.jgroupsDefaultConfig();
        } else if (control.matchesID(JGROUPS_URL_CONTROL)) {
            this.jgroupsURLConfig();
        }
    }

    protected void jgroupsDefaultConfig() {
        JGroupsConfigPanel view = (JGroupsConfigPanel)this.existingCards.get("JavaGroups Multicast (Default)");
        if (view != null) {
            view.showDefaultConfig();
        }
    }

    protected void jgroupsURLConfig() {
        JGroupsConfigPanel view = (JGroupsConfigPanel)this.existingCards.get("JavaGroups Multicast (Default)");
        if (view != null) {
            view.showCustomConfig();
        }
    }

    protected void commitChanges() {
        logObj.info("Has changes?: " + this.modified);
        if (this.modified) {
            CacheSyncTypesModel topModel = (CacheSyncTypesModel)this.getModel();
            SPanel card = (SPanel)this.existingCards.get(topModel.getFactoryLabel());
            CacheSyncConfigModel model = (CacheSyncConfigModel)card.getShownModel();
            DataDomain domain = this.eventController.getCurrentDataDomain();
            logObj.warn("domain properties BEFORE: " + domain.getProperties());
            model.storeProperties(domain.getProperties());
            logObj.warn("domain properties: " + domain.getProperties());
            this.eventController.fireDomainEvent(new DomainEvent((Object)this, domain));
        }
        this.shutdown();
    }

    protected void changeConfigView() {
        CacheSyncTypesModel topModel = (CacheSyncTypesModel)this.getModel();
        CacheSyncConfigModel newModel = this.buildModel(topModel);
        String label = topModel.getFactoryLabel();
        SPanel card = (SPanel)this.existingCards.get(label);
        card.setBoundModel(newModel);
        ((CacheSyncConfigDialog)this.getView()).showCard(label);
    }

    protected CacheSyncTypesModel buildTypesModel(String factory) {
        if (factory == null) {
            factory = JGROUPS_FACTORY_CLASS;
        }
        String label = JGROUPS_FACTORY_CLASS.equals(factory) ? "JavaGroups Multicast (Default)" : (JMS_FACTORY_CLASS.equals(factory) ? "JMS Transport" : "Custom Transport");
        CacheSyncTypesModel model = new CacheSyncTypesModel();
        model.setFactoryLabel(label);
        model.addModelChangeListener(this);
        return model;
    }

    protected CacheSyncConfigModel buildModel(CacheSyncTypesModel topModel) {
        String label = topModel.getFactoryLabel();
        String factory = label.equals("JavaGroups Multicast (Default)") ? JGROUPS_FACTORY_CLASS : (label.equals("JMS Transport") ? JMS_FACTORY_CLASS : null);
        return this.buildModel(factory);
    }

    protected CacheSyncConfigModel buildModel(String factory) {
        CacheSyncConfigModel model = JGROUPS_FACTORY_CLASS.equals(factory) ? new JGroupsConfigModel() : (JMS_FACTORY_CLASS.equals(factory) ? new JMSConfigModel() : new CacheSyncConfigModel());
        model.setMap(new HashMap(this.eventController.getCurrentDataDomain().getProperties()));
        model.setFactoryClass(factory);
        model.addModelChangeListener(this);
        return model;
    }

    protected void prepareChildren(String factory) {
        this.existingCards = new HashMap();
        CacheSyncConfigDialog topView = (CacheSyncConfigDialog)this.getView();
        JGroupsConfigPanel jgroupsPanel = new JGroupsConfigPanel();
        this.existingCards.put("JavaGroups Multicast (Default)", jgroupsPanel);
        topView.addCard(jgroupsPanel, "JavaGroups Multicast (Default)");
        JMSConfigPanel jmsPanel = new JMSConfigPanel();
        this.existingCards.put("JMS Transport", jmsPanel);
        topView.addCard(jmsPanel, "JMS Transport");
        CustomRemoteEventsConfigPanel customFactoryPanel = new CustomRemoteEventsConfigPanel();
        this.existingCards.put("Custom Transport", customFactoryPanel);
        topView.addCard(customFactoryPanel, "Custom Transport");
        if (factory == null) {
            factory = JGROUPS_FACTORY_CLASS;
        }
        CacheSyncConfigModel model = this.buildModel(factory);
        if (JGROUPS_FACTORY_CLASS.equals(factory)) {
            jgroupsPanel.setBoundModel(model);
            ((CacheSyncConfigDialog)this.getView()).showCard("JavaGroups Multicast (Default)");
        } else if (JMS_FACTORY_CLASS.equals(factory)) {
            jmsPanel.setBoundModel(model);
            ((CacheSyncConfigDialog)this.getView()).showCard("JMS Transport");
        } else {
            customFactoryPanel.setBoundModel(model);
            ((CacheSyncConfigDialog)this.getView()).showCard("Custom Transport");
        }
    }
}

