/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizardView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class DataSourceWizard
extends CayenneController {
    protected DataSourceWizardView view = new DataSourceWizardView(this);
    protected DBConnectionInfo altDataSource;
    protected String altDataSourceKey;
    protected ObjectBinding dataSourceBinding;
    protected Map dataSources;
    protected String dataSourceKey;
    protected DBConnectionInfo connectionInfo;
    protected boolean canceled;

    public DataSourceWizard(CayenneController parent, String title, String altDataSourceKey, DBConnectionInfo altDataSource) {
        super(parent);
        this.view.setTitle(title);
        this.altDataSource = altDataSource;
        this.altDataSourceKey = altDataSourceKey;
        this.connectionInfo = new DBConnectionInfo();
        this.initBindings();
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.dataSourceBinding = builder.bindToComboSelection(this.view.getDataSources(), "dataSourceKey");
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getOkButton(), "okAction()");
        builder.bindToAction(this.view.getConfigButton(), "dataSourceConfigAction()");
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    public void setDataSourceKey(String dataSourceKey) {
        this.dataSourceKey = dataSourceKey;
        DBConnectionInfo currentInfo = (DBConnectionInfo)this.dataSources.get(dataSourceKey);
        if (currentInfo != null) {
            currentInfo.copyTo(this.connectionInfo);
        } else {
            this.connectionInfo = new DBConnectionInfo();
        }
        this.view.getConnectionInfo().setConnectionInfo(this.connectionInfo);
    }

    public boolean startupAction() {
        this.canceled = true;
        this.refreshDataSources();
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
        return !this.canceled;
    }

    public DBConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void okAction() {
        DBConnectionInfo info = this.getConnectionInfo();
        ClassLoadingService classLoader = this.getApplication().getClassLoadingService();
        try {
            info.makeAdapter(classLoader);
        }
        catch (Throwable th) {
            this.reportError("DbAdapter Error", th);
            return;
        }
        try {
            Connection connection = info.makeDataSource(classLoader).getConnection();
            try {
                connection.close();
            }
            catch (SQLException ex) {}
        }
        catch (Throwable th) {
            this.reportError("Connection Error", th);
            return;
        }
        this.canceled = false;
        this.view.dispose();
    }

    public void cancelAction() {
        this.canceled = true;
        this.view.dispose();
    }

    public void dataSourceConfigAction() {
        PreferenceDialog prefs = new PreferenceDialog(this);
        prefs.showDataSourceEditorAction(this.dataSourceKey);
        this.refreshDataSources();
    }

    public Component getView() {
        return this.view;
    }

    protected void refreshDataSources() {
        this.dataSources = this.getApplication().getPreferenceDomain().getDetailsMap(DBConnectionInfo.class);
        Iterator it = this.dataSources.values().iterator();
        String _12package = "org.objectstyle.cayenne.";
        while (it.hasNext()) {
            DBConnectionInfo info = (DBConnectionInfo)it.next();
            if (info.getDbAdapter() == null || !info.getDbAdapter().startsWith("org.objectstyle.cayenne.")) continue;
            info.setDbAdapter("org.apache.cayenne." + info.getDbAdapter().substring("org.objectstyle.cayenne.".length()));
            info.getObjectContext().commitChanges();
        }
        if (this.altDataSourceKey != null && !this.dataSources.containsKey(this.altDataSourceKey) && this.altDataSource != null) {
            this.dataSources.put(this.altDataSourceKey, this.altDataSource);
        }
        Object[] keys = this.dataSources.keySet().toArray();
        Arrays.sort(keys);
        this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
        if (this.getDataSourceKey() == null) {
            String key = null;
            if (this.altDataSourceKey != null) {
                key = this.altDataSourceKey;
            } else if (keys.length > 0) {
                key = keys[0].toString();
            }
            this.setDataSourceKey(key);
            this.dataSourceBinding.updateView();
        }
    }
}

