/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.util.EntityMergeSupport;

public class EntitySyncController
extends CayenneController {
    protected DbEntity dbEntity;
    protected ObjEntity objEntity;
    protected EntitySyncDialog view;

    public EntitySyncController(CayenneController parent, DbEntity dbEntity) {
        super(parent);
        this.dbEntity = dbEntity;
    }

    public EntitySyncController(CayenneController parent, ObjEntity objEntity) {
        this(parent, objEntity.getDbEntity());
        this.objEntity = objEntity;
    }

    public EntityMergeSupport createMerger() {
        Collection entities = this.getObjEntities();
        if (entities.isEmpty()) {
            return null;
        }
        EntityMergeSupport merger = new EntityMergeSupport(this.dbEntity.getDataMap());
        boolean showDialog = false;
        for (ObjEntity entity : entities) {
            if (merger.getMeaningfulFKs(entity).isEmpty()) continue;
            showDialog = true;
            break;
        }
        return showDialog ? this.configureMerger(merger) : merger;
    }

    protected EntityMergeSupport configureMerger(final EntityMergeSupport merger) {
        final boolean[] cancel = new boolean[1];
        this.view = new EntitySyncDialog();
        this.view.getUpdateButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                merger.setRemoveMeaningfulFKs(EntitySyncController.this.view.getRemoveFKs().isSelected());
                EntitySyncController.this.view.dispose();
            }
        });
        this.view.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                cancel[0] = true;
                EntitySyncController.this.view.dispose();
            }
        });
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.show();
        return cancel[0] ? null : merger;
    }

    public Component getView() {
        return this.view;
    }

    protected Collection getObjEntities() {
        return this.objEntity != null ? Collections.singleton(this.objEntity) : this.dbEntity.getDataMap().getMappedEntities(this.dbEntity);
    }
}

