/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.util.Collection;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ResolveDbRelationshipDialog;
import org.apache.cayenne.modeler.dialog.objentity.EntityRelationshipsModel;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoDialog;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoModel;
import org.apache.cayenne.project.NamedObjectFactory;
import org.scopemvc.controller.basic.BasicController;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;

public class ObjRelationshipInfoController
extends BasicController {
    public static final String SAVE_CONTROL = "cayenne.modeler.mapObjRelationship.save.button";
    public static final String CANCEL_CONTROL = "cayenne.modeler.mapObjRelationship.cancel.button";
    public static final String NEW_TOONE_CONTROL = "cayenne.modeler.mapObjRelationship.newtoone.button";
    public static final String NEW_TOMANY_CONTROL = "cayenne.modeler.mapObjRelationship.newtomany.button";
    protected ProjectController mediator;

    public ObjRelationshipInfoController(ProjectController mediator, ObjRelationship relationship) {
        this.mediator = mediator;
        Collection<ObjEntity> objEntities = mediator.getCurrentDataMap().getNamespace().getObjEntities();
        ObjRelationshipInfoModel model = new ObjRelationshipInfoModel(relationship, objEntities);
        this.setModel(model);
    }

    public void startup() {
        ObjRelationshipInfoDialog view = new ObjRelationshipInfoDialog();
        this.setView(view);
        view.initFromModel();
        super.startup();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID(CANCEL_CONTROL)) {
            this.shutdown();
        } else if (control.matchesID(SAVE_CONTROL)) {
            this.saveMapping();
        } else if (control.matchesID(NEW_TOONE_CONTROL)) {
            this.createRelationship(false);
        } else if (control.matchesID(NEW_TOMANY_CONTROL)) {
            this.createRelationship(true);
        }
    }

    protected void saveMapping() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)this.getModel();
        if (model.savePath()) {
            this.mediator.fireObjRelationshipEvent(new RelationshipEvent((Object)Application.getFrame(), model.getRelationship(), model.getRelationship().getSourceEntity()));
        }
        this.shutdown();
    }

    protected void createRelationship(boolean toMany) {
        this.cancelEditing();
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)this.getModel();
        DbEntity source = model.getStartEntity();
        DbEntity target = model.getEndEntity();
        EntityRelationshipsModel selectedPathComponent = model.getSelectedPathComponent();
        if (selectedPathComponent != null) {
            source = (DbEntity)selectedPathComponent.getSourceEntity();
        }
        DbRelationship dbRelationship = (DbRelationship)NamedObjectFactory.createRelationship(source, target, toMany);
        dbRelationship.setSourceEntity(source);
        dbRelationship.setTargetEntity(target);
        dbRelationship.setToMany(toMany);
        source.addRelationship(dbRelationship);
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(dbRelationship);
        dialog.setVisible(true);
        if (dialog.isCancelPressed()) {
            source.removeRelationship(dbRelationship.getName());
        } else {
            if (selectedPathComponent == null) {
                selectedPathComponent = (EntityRelationshipsModel)model.getDbRelationshipPath().get(0);
                model.setSelectedPathComponent(selectedPathComponent);
            }
            selectedPathComponent.setRelationshipName(dbRelationship.getName());
        }
        dialog.dispose();
    }

    protected void cancelEditing() {
        ((ObjRelationshipInfoDialog)this.getView()).cancelTableEditing();
    }
}

