/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.apache.cayenne.modeler.dialog.objentity.EntityRelationshipsModel;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoModel;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.scopemvc.core.Selector;
import org.scopemvc.view.swing.SAction;
import org.scopemvc.view.swing.SButton;
import org.scopemvc.view.swing.SComboBox;
import org.scopemvc.view.swing.SLabel;
import org.scopemvc.view.swing.SListCellRenderer;
import org.scopemvc.view.swing.SPanel;
import org.scopemvc.view.swing.STable;
import org.scopemvc.view.swing.STableModel;
import org.scopemvc.view.swing.STextField;
import org.scopemvc.view.swing.SwingView;

public class ObjRelationshipInfoDialog
extends SPanel {
    protected STable pathTable;
    protected Component collectionTypeLabel;
    protected SComboBox collectionTypeCombo;
    protected Component mapKeysLabel;
    protected SComboBox mapKeysCombo;

    public ObjRelationshipInfoDialog() {
        this.init();
    }

    protected void init() {
        SButton saveButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.save.button"));
        saveButton.setEnabled(true);
        SButton cancelButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.cancel.button"));
        cancelButton.setEnabled(true);
        SButton newToOneButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.newtoone.button"));
        newToOneButton.setEnabled(true);
        SButton newToManyButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.newtomany.button"));
        newToManyButton.setEnabled(true);
        STextField relationshipName = new STextField(25);
        relationshipName.setSelector(ObjRelationshipInfoModel.RELATIONSHIP_NAME_SELECTOR);
        SLabel sourceEntityLabel = new SLabel();
        sourceEntityLabel.setSelector(ObjRelationshipInfoModel.SOURCE_ENTITY_NAME_SELECTOR);
        SComboBox targetCombo = new SComboBox();
        targetCombo.setSelector(ObjRelationshipInfoModel.OBJECT_TARGETS_SELECTOR);
        targetCombo.setSelectionSelector(ObjRelationshipInfoModel.OBJECT_TARGET_SELECTOR);
        SListCellRenderer renderer = (SListCellRenderer)targetCombo.getRenderer();
        renderer.setTextSelector("name");
        this.collectionTypeCombo = new SComboBox();
        this.collectionTypeCombo.setSelector(ObjRelationshipInfoModel.TARGET_COLLECTIONS_SELECTOR);
        this.collectionTypeCombo.setSelectionSelector(ObjRelationshipInfoModel.TARGET_COLLECTION_SELECTOR);
        this.mapKeysCombo = new SComboBox();
        this.mapKeysCombo.setSelector(ObjRelationshipInfoModel.MAP_KEYS_SELECTOR);
        this.mapKeysCombo.setSelectionSelector(ObjRelationshipInfoModel.MAP_KEY_SELECTOR);
        this.pathTable = new ObjRelationshipPathTable();
        STableModel pathTableModel = new STableModel(this.pathTable);
        pathTableModel.setSelector(ObjRelationshipInfoModel.DB_RELATIONSHIP_PATH_SELECTOR);
        pathTableModel.setColumnNames(new String[]{"DbRelationships"});
        pathTableModel.setColumnSelectors(new Selector[]{EntityRelationshipsModel.RELATIONSHIP_DISPLAY_NAME_SELECTOR});
        this.pathTable.setModel(pathTableModel);
        this.pathTable.setSelectionSelector(ObjRelationshipInfoModel.SELECTED_PATH_COMPONENT_SELECTOR);
        this.pathTable.getColumn("DbRelationships").setCellEditor(this.createRelationshipEditor());
        this.collectionTypeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                ObjRelationshipInfoDialog.this.initFromModel();
            }
        });
        this.setDisplayMode(1);
        this.setTitle("ObjRelationship Inspector");
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(50dlu;pref), 3dlu, fill:min(150dlu;pref), 3dlu, fill:min(120dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:14dlu, 3dlu, top:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addSeparator("ObjRelationship Information", cc.xywh(1, 1, 5, 1));
        builder.addLabel("Relationship:", cc.xy(1, 3));
        builder.add((Component)relationshipName, cc.xywh(3, 3, 1, 1));
        builder.addLabel("Source:", cc.xy(1, 5));
        builder.add((Component)sourceEntityLabel, cc.xywh(3, 5, 1, 1));
        builder.addLabel("Target:", cc.xy(1, 7));
        builder.add((Component)targetCombo, cc.xywh(3, 7, 1, 1));
        this.collectionTypeLabel = builder.addLabel("Collection Type:", cc.xy(1, 9));
        builder.add((Component)this.collectionTypeCombo, cc.xywh(3, 9, 1, 1));
        this.mapKeysLabel = builder.addLabel("Map Key:", cc.xy(1, 11));
        builder.add((Component)this.mapKeysCombo, cc.xywh(3, 11, 1, 1));
        builder.addSeparator("Mapping to DbRelationships", cc.xywh(1, 13, 5, 1));
        builder.add((Component)new JScrollPane(this.pathTable), cc.xywh(1, 15, 3, 3));
        JPanel newRelationshipsButtons = new JPanel(new FlowLayout(3));
        newRelationshipsButtons.add(newToOneButton);
        newRelationshipsButtons.add(newToManyButton);
        builder.add((Component)newRelationshipsButtons, cc.xywh(5, 15, 1, 3));
        this.add((Component)builder.getPanel(), "Center");
        this.add((Component)PanelFactory.createButtonPanel(new JButton[]{saveButton, cancelButton}), "South");
    }

    public void cancelTableEditing() {
        int row = this.pathTable.getEditingRow();
        if (row < 0) {
            return;
        }
        int column = this.pathTable.getEditingColumn();
        if (column < 0) {
            return;
        }
        TableCellEditor editor = this.pathTable.getCellEditor(row, column);
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    void initFromModel() {
        if (this.getController() == null || this.getController().getModel() == null) {
            return;
        }
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)this.getController().getModel();
        boolean collectionTypeEnabled = model.isToMany();
        this.collectionTypeCombo.setEnabled(collectionTypeEnabled);
        this.collectionTypeLabel.setEnabled(collectionTypeEnabled);
        boolean mapKeysEnabled = collectionTypeEnabled && "java.util.Map".equals(this.collectionTypeCombo.getSelectedItem());
        this.mapKeysCombo.setEnabled(mapKeysEnabled);
        this.mapKeysLabel.setEnabled(mapKeysEnabled);
    }

    TableCellEditor createRelationshipEditor() {
        JComboBox relationshipCombo = new JComboBox();
        relationshipCombo.setEditable(false);
        relationshipCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ObjRelationshipInfoDialog.this.initFromModel();
            }
        });
        return new RelationshipPicker(this, relationshipCombo);
    }

    final class RelationshipPicker
    extends DefaultCellEditor {
        JComboBox comboBox;
        SwingView view;

        RelationshipPicker(SwingView view, JComboBox comboBox) {
            super(comboBox);
            this.comboBox = comboBox;
            this.view = view;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)this.view.getBoundModel();
            EntityRelationshipsModel relationshipWrapper = (EntityRelationshipsModel)model.getDbRelationshipPath().get(row);
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(relationshipWrapper.getRelationshipNames());
            comboModel.setSelectedItem(value);
            this.comboBox.setModel(comboModel);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class ObjRelationshipPathTable
    extends STable {
        final Dimension preferredSize = new Dimension(203, 100);

        ObjRelationshipPathTable() {
            this.setRowHeight(25);
            this.setRowMargin(3);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.preferredSize;
        }
    }
}

