/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.cayenne.modeler.dialog.pref.CayenneModelerPreferenceEditor;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferences;
import org.apache.cayenne.modeler.dialog.pref.DataSourcePreferences;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialogView;
import org.apache.cayenne.modeler.dialog.pref.TemplatePreferences;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.PreferenceEditor;

public class PreferenceDialog
extends CayenneController {
    public static final String GENERAL_KEY = "General";
    public static final String DATA_SOURCES_KEY = "Local DataSources";
    public static final String CLASS_PATH_KEY = "ClassPath";
    public static final String TEMPLATES_KEY = "Templates";
    private static final String[] preferenceMenus = new String[]{"General", "Local DataSources", "ClassPath", "Templates"};
    protected PreferenceDialogView view;
    protected Map detailControllers;
    protected PreferenceEditor editor;

    public PreferenceDialog(CayenneController parent) {
        super(parent);
        Window parentView = (Window)SwingUtilities.getAncestorOfClass(Window.class, parent.getView());
        this.view = parentView instanceof Dialog ? new PreferenceDialogView((Dialog)parentView) : new PreferenceDialogView((Frame)parentView);
        this.detailControllers = new HashMap();
        this.editor = new CayenneModelerPreferenceEditor(this.application);
        this.initBindings();
    }

    protected void initBindings() {
        final JList list = this.view.getList();
        list.setListData(preferenceMenus);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object selection = list.getSelectedValue();
                if (selection != null) {
                    PreferenceDialog.this.view.getDetailLayout().show(PreferenceDialog.this.view.getDetailPanel(), selection.toString());
                }
            }
        });
        this.view.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferenceDialog.this.cancelAction();
            }
        });
        this.view.getSaveButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferenceDialog.this.savePreferencesAction();
            }
        });
    }

    public void cancelAction() {
        this.editor.revert();
        this.view.dispose();
    }

    public void savePreferencesAction() {
        this.editor.save();
        this.view.dispose();
    }

    public void showDataSourceEditorAction(Object dataSourceKey) {
        this.configure();
        this.view.getDetailLayout().show(this.view.getDetailPanel(), DATA_SOURCES_KEY);
        DataSourcePreferences controller = (DataSourcePreferences)this.detailControllers.get(DATA_SOURCES_KEY);
        controller.editDataSourceAction(dataSourceKey);
        this.view.setVisible(true);
    }

    public void startupAction(String key) {
        if (key == null) {
            key = GENERAL_KEY;
        }
        this.configure();
        this.view.getList().setSelectedValue(key, true);
        this.view.setVisible(true);
    }

    protected void configure() {
        this.registerPanel(GENERAL_KEY, new GeneralPreferences(this));
        this.registerPanel(DATA_SOURCES_KEY, new DataSourcePreferences(this));
        this.registerPanel(CLASS_PATH_KEY, new ClasspathPreferences(this));
        this.registerPanel(TEMPLATES_KEY, new TemplatePreferences(this));
        this.view.getDetailLayout().show(this.view.getDetailPanel(), GENERAL_KEY);
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
    }

    protected void registerPanel(String name, CayenneController panelController) {
        this.detailControllers.put(name, panelController);
        this.view.getDetailPanel().add(panelController.getView(), name);
    }

    public Component getView() {
        return this.view;
    }

    public PreferenceEditor getEditor() {
        return this.editor;
    }
}

