/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjAttributeTableModel
extends CayenneTableModel {
    static final int OBJ_ATTRIBUTE = 0;
    static final int OBJ_ATTRIBUTE_TYPE = 1;
    static final int DB_ATTRIBUTE = 2;
    static final int DB_ATTRIBUTE_TYPE = 3;
    static final int LOCKING = 4;
    protected ObjEntity entity;
    protected DbEntity dbEntity;

    public ObjAttributeTableModel(ObjEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList<ObjAttribute>(entity.getAttributes()));
        this.entity = entity;
        this.dbEntity = entity.getDbEntity();
        Collections.sort(this.objectList, new AttributeComparator());
    }

    @Override
    protected void orderList() {
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 4: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Class<?> getElementsClass() {
        return ObjAttribute.class;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public ObjAttribute getAttribute(int row) {
        return row >= 0 && row < this.objectList.size() ? (ObjAttribute)this.objectList.get(row) : null;
    }

    public void resetDbEntity() {
        if (this.dbEntity == this.entity.getDbEntity()) {
            return;
        }
        boolean wasShowing = this.isShowingDb();
        this.dbEntity = this.entity.getDbEntity();
        boolean isShowing = this.isShowingDb();
        if (wasShowing != isShowing) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    private boolean isShowingDb() {
        return this.dbEntity != null;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "ObjAttribute";
            }
            case 1: {
                return "Java Type";
            }
            case 2: {
                return "DbAttribute";
            }
            case 3: {
                return "DB Type";
            }
            case 4: {
                return "Used for Locking";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        ObjAttribute attribute = this.getAttribute(row);
        if (column == 0) {
            return attribute.getName();
        }
        if (column == 1) {
            return attribute.getType();
        }
        if (column == 4) {
            return attribute.isUsedForLocking() ? Boolean.TRUE : Boolean.FALSE;
        }
        DbAttribute dbAttribute = attribute.getDbAttribute();
        if (dbAttribute == null) {
            return null;
        }
        if (column == 2) {
            return dbAttribute.getName();
        }
        if (column == 3) {
            return TypesMapping.getSqlNameByType(dbAttribute.getType());
        }
        return null;
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int column) {
        ObjAttribute attribute = this.getAttribute(row);
        AttributeEvent event = new AttributeEvent(this.eventSource, attribute, this.entity);
        if (column == 0) {
            event.setOldName(attribute.getName());
            ProjectUtil.setAttributeName(attribute, value != null ? value.toString().trim() : null);
            this.fireTableCellUpdated(row, column);
        } else if (column == 1) {
            attribute.setType(value != null ? value.toString() : null);
            this.fireTableCellUpdated(row, column);
        } else if (column == 4) {
            attribute.setUsedForLocking(value instanceof Boolean && (Boolean)value != false);
            this.fireTableCellUpdated(row, column);
        } else {
            if (column == 2) {
                if (value != null) {
                    DbAttribute dbAttribute = (DbAttribute)this.dbEntity.getAttribute(value.toString());
                    String path = dbAttribute != null ? dbAttribute.getName() : null;
                    attribute.setDbAttributePath(path);
                } else if (attribute.getDbAttribute() != null) {
                    attribute.setDbAttributePath(null);
                }
            }
            this.fireTableRowsUpdated(row, row);
        }
        this.mediator.fireObjAttributeEvent(event);
    }

    private boolean isInherited(int row) {
        ObjAttribute attribute = this.getAttribute(row);
        return attribute != null ? attribute.getEntity() != this.entity : false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.isInherited(row)) {
            return false;
        }
        if (this.dbEntity == null) {
            return col != 3 && col != 2;
        }
        return col != 3;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    final class AttributeComparator
    implements Comparator {
        AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Attribute a1 = (Attribute)o1;
            Attribute a2 = (Attribute)o2;
            int delta = this.getWeight(a1) - this.getWeight(a2);
            return delta != 0 ? delta : Util.nullSafeCompare(true, a1.getName(), a2.getName());
        }

        private int getWeight(Attribute a) {
            return a.getEntity() == ObjAttributeTableModel.this.entity ? 1 : -1;
        }
    }
}

