/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;

public class ObjEntityAttributeTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjAttributeListener,
ExistingSelectionProcessor {
    protected ProjectController mediator;
    protected CayenneTable table;

    public ObjEntityAttributeTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(ObjEntitySyncAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(RemoveAttributeAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjAttributeListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObjEntityAttributeTab.this.processExistingSelection(e);
            }
        });
    }

    public void selectAttribute(ObjAttribute attr) {
        if (attr == null) {
            Application.getInstance().getAction(RemoveAttributeAction.getActionName()).setEnabled(false);
            return;
        }
        Application.getInstance().getAction(RemoveAttributeAction.getActionName()).setEnabled(true);
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        List attrs = model.getObjectList();
        int attrPos = attrs.indexOf(attr);
        if (attrPos >= 0) {
            this.table.select(attrPos);
        }
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        ObjAttribute attribute = null;
        if (this.table.getSelectedRow() >= 0) {
            ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
            attribute = model.getAttribute(this.table.getSelectedRow());
            UIUtil.scrollToSelectedRow(this.table);
        }
        AttributeDisplayEvent ev = new AttributeDisplayEvent((Object)this, attribute, this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireObjAttributeDisplayEvent(ev);
    }

    public void objAttributeChanged(AttributeEvent e) {
        this.table.select(e.getAttribute());
    }

    public void objAttributeAdded(AttributeEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getAttribute());
    }

    public void objAttributeRemoved(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getAttribute());
        model.removeRow(e.getAttribute());
        this.table.select(ind);
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(ObjEntity entity) {
        ObjAttributeTableModel model = new ObjAttributeTableModel(entity, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure(model);
    }

    protected void setUpTableStructure(ObjAttributeTableModel model) {
        TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
        nameColumn.setMinWidth(150);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(1);
        typeColumn.setMinWidth(150);
        JComboBox javaTypesCombo = CayenneWidgetFactory.createComboBox(ModelerUtil.getRegisteredTypeNames(), false);
        javaTypesCombo.setEditable(true);
        typeColumn.setCellEditor(new DefaultCellEditor(javaTypesCombo));
        TableColumn lockColumn = this.table.getColumnModel().getColumn(4);
        lockColumn.setMinWidth(100);
        TableColumn dbTypeColumn = this.table.getColumnModel().getColumn(3);
        dbTypeColumn.setMinWidth(120);
        TableColumn dbNameColumn = this.table.getColumnModel().getColumn(2);
        dbNameColumn.setMinWidth(150);
        if (model.getEntity().getDbEntity() != null) {
            JComboBox dbAttributesCombo = CayenneWidgetFactory.createComboBox(ModelerUtil.getDbAttributeNames(this.mediator, model.getEntity().getDbEntity()), true);
            dbAttributesCombo.setEditable(false);
            dbNameColumn.setCellEditor(new DefaultCellEditor(dbAttributesCombo));
        }
    }

    public void objEntityChanged(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        if (!(this.table.getModel() instanceof ObjAttributeTableModel)) {
            return;
        }
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (model.getDbEntity() != ((ObjEntity)e.getEntity()).getDbEntity()) {
            model.resetDbEntity();
            this.setUpTableStructure(model);
        }
    }

    public void objEntityAdded(EntityEvent e) {
    }

    public void objEntityRemoved(EntityEvent e) {
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjAttributeTableModel model = (ObjAttributeTableModel)table.getModel();
            ObjAttribute attribute = model.getAttribute(row);
            if (attribute != null && attribute.getEntity() != model.getEntity()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            return this;
        }
    }
}

