/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.ObjectQueryPropertiesPanel;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ExpressionConvertor;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class SelectQueryMainTab
extends JPanel {
    protected ProjectController mediator;
    protected TextAdapter name;
    protected JComboBox queryRoot;
    protected TextAdapter qualifier;
    protected JCheckBox distinct;
    protected ObjectQueryPropertiesPanel properties;

    public SelectQueryMainTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                SelectQueryMainTab.this.setQueryName(text);
            }
        };
        this.queryRoot = CayenneWidgetFactory.createComboBox();
        this.queryRoot.setRenderer(CellRenderers.listRendererWithIcons());
        this.qualifier = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                SelectQueryMainTab.this.setQueryQualifier(text);
            }
        };
        this.distinct = new JCheckBox();
        this.properties = new ObjectQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:200dlu", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("SelectQuery Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        builder.addLabel("Query Root:", cc.xy(1, 5));
        builder.add((Component)this.queryRoot, cc.xy(3, 5));
        builder.addLabel("Qualifier:", cc.xy(1, 7));
        builder.add((Component)this.qualifier.getComponent(), cc.xy(3, 7));
        builder.addLabel("Distinct:", cc.xy(1, 9));
        builder.add((Component)this.distinct, cc.xy(3, 9));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    private void initController() {
        this.queryRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectQuery query = SelectQueryMainTab.this.getQuery();
                if (query != null) {
                    query.setRoot(SelectQueryMainTab.this.queryRoot.getModel().getSelectedItem());
                    SelectQueryMainTab.this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
                }
            }
        });
        this.distinct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectQuery query = SelectQueryMainTab.this.getQuery();
                if (query != null) {
                    query.setDistinct(SelectQueryMainTab.this.distinct.isSelected());
                    SelectQueryMainTab.this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
                }
            }
        });
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof SelectQuery)) {
            this.setVisible(false);
            return;
        }
        SelectQuery selectQuery = (SelectQuery)query;
        this.name.setText(query.getName());
        this.distinct.setSelected(selectQuery.isDistinct());
        this.qualifier.setText(selectQuery.getQualifier() != null ? selectQuery.getQualifier().toString() : null);
        DataMap map = this.mediator.getCurrentDataMap();
        Object[] roots = map.getObjEntities().toArray();
        if (roots.length > 1) {
            Arrays.sort(roots, Comparators.getDataMapChildrenComparator());
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(roots);
        model.setSelectedItem(selectQuery.getRoot());
        this.queryRoot.setModel(model);
        this.properties.initFromModel(selectQuery);
        this.setVisible(true);
    }

    protected SelectQuery getQuery() {
        return this.mediator.getCurrentQuery() instanceof SelectQuery ? (SelectQuery)this.mediator.getCurrentQuery() : null;
    }

    void setQueryQualifier(String text) {
        SelectQuery query;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        ExpressionConvertor convertor = new ExpressionConvertor();
        try {
            String oldQualifier = convertor.valueAsString(query.getQualifier());
            if (!Util.nullSafeEquals(oldQualifier, text)) {
                Expression exp = (Expression)convertor.stringAsValue(text);
                query.setQualifier(exp);
                this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException(ex.getMessage());
        }
    }

    void setQueryName(String newName) {
        SelectQuery query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("SelectQuery name is required.");
        }
        DataMap map = this.mediator.getCurrentDataMap();
        Query matchingQuery = map.getQuery(newName);
        if (matchingQuery == null) {
            QueryEvent e = new QueryEvent((Object)this, (Query)query, query.getName());
            ProjectUtil.setQueryName(map, query, newName);
            this.mediator.fireQueryEvent(e);
        } else if (matchingQuery != query) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.");
        }
    }
}

