/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.datanode.DataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.JDBCDataSourceView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;

public class JDBCDataSourceEditor
extends DataSourceEditor {
    protected JDBCDataSourceView view;

    public JDBCDataSourceEditor(ProjectController parent, BindingDelegate nodeChangeProcessor) {
        super(parent, nodeChangeProcessor);
    }

    public Component getView() {
        return this.view;
    }

    protected void prepareBindings(BindingBuilder builder) {
        this.view = new JDBCDataSourceView();
        this.fieldAdapters = new ObjectBinding[10];
        this.fieldAdapters[0] = builder.bindToTextField(this.view.getUserName(), "node.dataSource.dataSourceInfo.userName");
        this.fieldAdapters[1] = builder.bindToTextField(this.view.getPassword(), "node.dataSource.dataSourceInfo.password");
        this.fieldAdapters[2] = builder.bindToTextField(this.view.getUrl(), "node.dataSource.dataSourceInfo.dataSourceUrl");
        this.fieldAdapters[3] = builder.bindToTextField(this.view.getDriver(), "node.dataSource.dataSourceInfo.jdbcDriver");
        this.fieldAdapters[4] = builder.bindToTextField(this.view.getMaxConnections(), "node.dataSource.dataSourceInfo.maxConnections");
        this.fieldAdapters[5] = builder.bindToTextField(this.view.getMinConnections(), "node.dataSource.dataSourceInfo.minConnections");
        this.fieldAdapters[6] = builder.bindToComboSelection(this.view.getPasswordEncoder(), "node.dataSource.dataSourceInfo.passwordEncoderClass");
        this.fieldAdapters[7] = builder.bindToTextField(this.view.getPasswordKey(), "node.dataSource.dataSourceInfo.passwordEncoderKey");
        this.fieldAdapters[8] = builder.bindToComboSelection(this.view.getPasswordLocation(), "node.dataSource.dataSourceInfo.passwordLocation");
        this.fieldAdapters[9] = builder.bindToTextField(this.view.getPasswordSource(), "node.dataSource.dataSourceInfo.passwordSource");
        builder.bindToAction(this.view.getPasswordEncoder(), "validatePasswordEncoderAction()");
        builder.bindToAction(this.view.getPasswordLocation(), "passwordLocationChangedAction()");
        builder.bindToAction(this.view.getSyncWithLocal(), "syncDataSourceAction()");
    }

    public void validatePasswordEncoderAction() {
        if (this.getNode() == null || this.getNode().getDataSource() == null) {
            return;
        }
        DataSourceInfo dsi = ((ProjectDataSource)this.getNode().getDataSource()).getDataSourceInfo();
        if (!this.view.getPasswordEncoder().getSelectedItem().equals(dsi.getPasswordEncoderClass())) {
            return;
        }
        if (dsi.getPasswordEncoder() == null) {
            JOptionPane.showMessageDialog(this.getView(), "A valid Password Encoder should be specified (check your CLASSPATH).", "Invalid Password Encoder", 0);
        }
    }

    private void updatePasswordElements(boolean isPasswordFieldEnabled, boolean isPasswordLocationEnabled, String passwordText, String passwordLocationLabel, String passwordLocationText) {
        this.view.getPassword().setEnabled(isPasswordFieldEnabled);
        this.view.getPassword().setText(passwordText);
        this.view.getPasswordSource().setEnabled(isPasswordLocationEnabled);
        this.view.getPasswordSourceLabel().setText(passwordLocationLabel);
        this.view.getPasswordSource().setText(passwordLocationText);
    }

    public void passwordLocationChangedAction() {
        if (this.getNode() == null || this.getNode().getDataSource() == null) {
            return;
        }
        DataSourceInfo dsi = ((ProjectDataSource)this.getNode().getDataSource()).getDataSourceInfo();
        String selectedItem = (String)this.view.getPasswordLocation().getSelectedItem();
        if (selectedItem.equals("classpath")) {
            this.updatePasswordElements(true, true, dsi.getPassword(), "Password Filename:", dsi.getPasswordSourceFilename());
        } else if (selectedItem.equals("executable")) {
            this.updatePasswordElements(false, true, null, "Password Executable:", dsi.getPasswordSourceExecutable());
        } else if (selectedItem.equals("model")) {
            this.updatePasswordElements(true, false, dsi.getPassword(), "Password Source:", dsi.getPasswordSourceModel());
        } else if (selectedItem.equals("url")) {
            this.updatePasswordElements(false, true, null, "Password URL:", dsi.getPasswordSourceUrl());
        }
    }

    public void syncDataSourceAction() {
        CayenneModelerController mainController = this.getApplication().getFrameController();
        if (this.getNode() == null || this.getNode().getDataSource() == null) {
            return;
        }
        ProjectDataSource projectDS = (ProjectDataSource)this.getNode().getDataSource();
        ProjectController parent = (ProjectController)this.getParent();
        String key = parent.getDataNodePreferences().getLocalDataSource();
        if (key == null) {
            mainController.updateStatus("No Local DataSource selected for node...");
            return;
        }
        DBConnectionInfo dataSource = (DBConnectionInfo)parent.getApplicationPreferenceDomain().getDetail(key, DBConnectionInfo.class, false);
        if (dataSource != null) {
            if (dataSource.copyTo(projectDS.getDataSourceInfo())) {
                this.refreshView();
                this.nodeChangeProcessor.modelUpdated(null, null, null);
                mainController.updateStatus(null);
            } else {
                mainController.updateStatus("DataNode is up to date...");
            }
        } else {
            mainController.updateStatus("Invalid Local DataSource selected for node...");
        }
    }
}

