/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.cayenne.conf.PasswordEncoding;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;

public class JDBCDataSourceView
extends JPanel {
    protected JTextField driver = new JTextField();
    protected JTextField url = new JTextField();
    protected JTextField userName = new JTextField();
    protected JPasswordField password = new JPasswordField();
    protected JComboBox passwordEncoder = new JComboBox();
    protected JComboBox passwordLocation = new JComboBox();
    protected JTextField passwordKey;
    protected JTextField passwordSource = new JTextField();
    protected JLabel passwordSourceLabel;
    protected JTextField minConnections;
    protected JTextField maxConnections;
    protected JButton syncWithLocal;
    private static final String PASSWORD_CLASSPATH = "Classpath Search (File System)";
    private static final String PASSWORD_EXECUTABLE = "Executable Program";
    private static final String PASSWORD_MODEL = "Cayenne Model";
    private static final String PASSWORD_URL = "URL (file:, http:, etc)";
    private static final Object[] PASSWORD_LOCATIONS = new Object[]{"model", "classpath", "executable", "url"};
    private static final Map<String, String> passwordSourceLabels = new TreeMap<String, String>();

    public JDBCDataSourceView() {
        this.passwordKey = new JTextField();
        this.minConnections = new JTextField(6);
        this.maxConnections = new JTextField(6);
        this.syncWithLocal = new JButton("Sync with Local");
        this.syncWithLocal.setToolTipText("Update from local DataSource");
        this.passwordEncoder.setModel(new DefaultComboBoxModel<String>(PasswordEncoding.standardEncoders));
        this.passwordEncoder.setEditable(true);
        this.passwordLocation = CayenneWidgetFactory.createComboBox();
        this.passwordLocation.setRenderer(new PasswordLocationRenderer());
        DefaultComboBoxModel<Object> passwordLocationModel = new DefaultComboBoxModel<Object>(PASSWORD_LOCATIONS);
        this.passwordLocation.setModel(passwordLocationModel);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:80dlu, 3dlu, fill:50dlu, 3dlu, fill:74dlu, 3dlu, fill:70dlu", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("JDBC Configuration", cc.xywh(1, 1, 7, 1));
        builder.addLabel("JDBC Driver:", cc.xy(1, 3));
        builder.add((Component)this.driver, cc.xywh(3, 3, 5, 1));
        builder.addLabel("DB URL:", cc.xy(1, 5));
        builder.add((Component)this.url, cc.xywh(3, 5, 5, 1));
        builder.addLabel("Username:", cc.xy(1, 7));
        builder.add((Component)this.userName, cc.xywh(3, 7, 5, 1));
        builder.addLabel("Password:", cc.xy(1, 9));
        builder.add((Component)this.password, cc.xywh(3, 9, 5, 1));
        builder.addLabel("Password Encoder:", cc.xy(1, 11));
        builder.add((Component)this.passwordEncoder, cc.xywh(3, 11, 5, 1));
        builder.addLabel("Password Encoder Key:", cc.xy(1, 13));
        builder.add((Component)this.passwordKey, cc.xywh(3, 13, 5, 1));
        builder.addLabel("Note: Cayenne supplied encoders do not use a key.", cc.xywh(3, 15, 5, 1));
        builder.addLabel("Password Location:", cc.xy(1, 17));
        builder.add((Component)this.passwordLocation, cc.xywh(3, 17, 5, 1));
        this.passwordSourceLabel = builder.addLabel("Password Source:", cc.xy(1, 19));
        builder.add((Component)this.passwordSource, cc.xywh(3, 19, 5, 1));
        builder.addLabel("Min Connections:", cc.xy(1, 21));
        builder.add((Component)this.minConnections, cc.xy(3, 21));
        builder.addLabel("Max Connections:", cc.xy(1, 23));
        builder.add((Component)this.maxConnections, cc.xy(3, 23));
        builder.add((Component)this.syncWithLocal, cc.xy(7, 25));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    public JTextField getDriver() {
        return this.driver;
    }

    public JPasswordField getPassword() {
        return this.password;
    }

    public JTextField getUrl() {
        return this.url;
    }

    public JTextField getUserName() {
        return this.userName;
    }

    public JTextField getMaxConnections() {
        return this.maxConnections;
    }

    public JTextField getMinConnections() {
        return this.minConnections;
    }

    public JButton getSyncWithLocal() {
        return this.syncWithLocal;
    }

    public JComboBox getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public JComboBox getPasswordLocation() {
        return this.passwordLocation;
    }

    public JTextField getPasswordKey() {
        return this.passwordKey;
    }

    public JTextField getPasswordSource() {
        return this.passwordSource;
    }

    public JLabel getPasswordSourceLabel() {
        return this.passwordSourceLabel;
    }

    static {
        passwordSourceLabels.put("model", PASSWORD_MODEL);
        passwordSourceLabels.put("classpath", PASSWORD_CLASSPATH);
        passwordSourceLabels.put("executable", PASSWORD_EXECUTABLE);
        passwordSourceLabels.put("url", PASSWORD_URL);
    }

    final class PasswordLocationRenderer
    extends DefaultListCellRenderer {
        PasswordLocationRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            object = object != null ? passwordSourceLabels.get(object) : JDBCDataSourceView.PASSWORD_MODEL;
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

