/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributeTab;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityRelationshipTab;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityTab;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.DbAttributeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DbRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;

public class DbEntityTabbedView
extends JTabbedPane
implements ChangeListener,
DbEntityDisplayListener,
DbRelationshipDisplayListener,
DbAttributeDisplayListener {
    protected ProjectController mediator;
    protected Component entityPanel;
    protected DbEntityAttributeTab attributesPanel;
    protected DbEntityRelationshipTab relationshipsPanel;

    public DbEntityTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        mediator.addDbEntityDisplayListener(this);
        mediator.addDbAttributeDisplayListener(this);
        mediator.addDbRelationshipDisplayListener(this);
        this.setTabPlacement(1);
        this.entityPanel = new JScrollPane(new DbEntityTab(mediator));
        this.addTab("Entity", this.entityPanel);
        this.attributesPanel = new DbEntityAttributeTab(mediator);
        this.addTab("Attributes", this.attributesPanel);
        this.relationshipsPanel = new DbEntityRelationshipTab(mediator);
        this.addTab("Relationships", this.relationshipsPanel);
        this.addChangeListener(this);
    }

    private void resetRemoveButtons() {
        Application app = Application.getInstance();
        app.getAction(RemoveAttributeAction.getActionName()).setEnabled(false);
        app.getAction(RemoveRelationshipAction.getActionName()).setEnabled(false);
    }

    public void stateChanged(ChangeEvent e) {
        this.resetRemoveButtons();
        Component selected = this.getSelectedComponent();
        while (selected instanceof JScrollPane) {
            selected = ((JScrollPane)selected).getViewport().getView();
        }
        ExistingSelectionProcessor proc = (ExistingSelectionProcessor)((Object)selected);
        proc.processExistingSelection(e);
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        Entity entity = e.getEntity();
        if (e.isMainTabFocus() && entity instanceof DbEntity && this.getSelectedComponent() != this.entityPanel) {
            this.setSelectedComponent(this.entityPanel);
            this.entityPanel.setVisible(true);
        }
        this.resetRemoveButtons();
        this.setVisible(e.getEntity() != null);
    }

    public void currentDbRelationshipChanged(RelationshipDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Relationship rel = e.getRelationship();
        if (rel instanceof DbRelationship) {
            if (this.getSelectedComponent() != this.relationshipsPanel) {
                this.setSelectedComponent(this.relationshipsPanel);
                this.relationshipsPanel.setVisible(true);
            }
            this.relationshipsPanel.selectRelationship((DbRelationship)rel);
        }
    }

    public void currentDbAttributeChanged(AttributeDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Attribute attr = e.getAttribute();
        if (attr instanceof DbAttribute) {
            if (this.getSelectedComponent() != this.attributesPanel) {
                this.setSelectedComponent(this.attributesPanel);
                this.attributesPanel.setVisible(true);
            }
            this.attributesPanel.selectAttribute((DbAttribute)attr);
        }
    }
}

