/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.Util;

public abstract class CayenneAction
extends AbstractAction {
    protected boolean alwaysOn;
    protected Application application;

    public CayenneAction(String name, Application application) {
        this(name, application, name);
    }

    public CayenneAction(String name, Application application, String shortDescription) {
        super(name);
        KeyStroke accelerator;
        super.putValue("Default", name);
        this.application = application;
        Icon icon = this.createIcon();
        if (icon != null) {
            super.putValue("SmallIcon", icon);
        }
        if ((accelerator = this.getAcceleratorKey()) != null) {
            super.putValue("AcceleratorKey", accelerator);
        }
        if (shortDescription != null && shortDescription.length() > 0) {
            super.putValue("ShortDescription", shortDescription);
        }
        this.setEnabled(false);
    }

    public Application getApplication() {
        return this.application;
    }

    protected Project getCurrentProject() {
        return this.application.getFrameController().getProjectController().getProject();
    }

    public void setName(String newName) {
        if (!Util.nullSafeEquals(this.getValue("Name"), newName)) {
            super.putValue("Name", newName);
        }
    }

    public KeyStroke getAcceleratorKey() {
        return null;
    }

    public String getIconName() {
        return null;
    }

    public Icon createIcon() {
        String name = this.getIconName();
        return name != null ? ModelerUtil.buildIcon(name) : null;
    }

    public String getKey() {
        return (String)super.getValue("Default");
    }

    public abstract void performAction(ActionEvent var1);

    public boolean enableForPath(ProjectPath obj) {
        return false;
    }

    public ProjectController getProjectController() {
        return this.application.getFrameController().getProjectController();
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.performAction(e);
        }
        catch (Throwable th) {
            ErrorDebugDialog.guiException(th);
        }
    }

    public JMenuItem buildMenu() {
        return new JMenuItem(this);
    }

    public JButton buildButton() {
        return new CayenneToolbarButton(this);
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    public void setAlwaysOn(boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
        if (alwaysOn) {
            super.setEnabled(true);
        }
    }

    public void setEnabled(boolean b) {
        if (!this.isAlwaysOn()) {
            super.setEnabled(b);
        }
    }

    final class CayenneToolbarButton
    extends JButton {
        protected boolean showingText;

        public CayenneToolbarButton(Action a) {
            this.setAction(a);
        }

        public boolean isShowingText() {
            return this.showingText;
        }

        public void setShowingText(boolean showingText) {
            this.showingText = showingText;
        }

        public String getText() {
            return this.showingText ? super.getText() : null;
        }

        public void setText(String text) {
            if (this.showingText) {
                super.setText(text);
            } else {
                super.setToolTipText(text);
            }
        }
    }
}

