/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;

public class CayenneTable
extends JTable {
    public CayenneTable() {
        this.setRowHeight(25);
        this.setRowMargin(3);
    }

    protected void createDefaultEditors() {
        super.createDefaultEditors();
        JTextField textField = CayenneWidgetFactory.createTextField(0);
        DefaultCellEditor textEditor = new DefaultCellEditor(textField);
        textEditor.setClickCountToStart(1);
        this.setDefaultEditor(Object.class, textEditor);
        this.setDefaultEditor(String.class, textEditor);
    }

    public CayenneTableModel getCayenneModel() {
        return (CayenneTableModel)this.getModel();
    }

    protected void cancelEditing() {
        this.editingCanceled(new ChangeEvent(this));
    }

    public void select(Object row) {
        if (row == null) {
            return;
        }
        this.cancelEditing();
        CayenneTableModel model = this.getCayenneModel();
        int ind = model.getObjectList().indexOf(row);
        if (ind >= 0) {
            this.getSelectionModel().setSelectionInterval(ind, ind);
        }
    }

    public void select(int index) {
        this.cancelEditing();
        CayenneTableModel model = this.getCayenneModel();
        if (index >= model.getObjectList().size()) {
            index = model.getObjectList().size() - 1;
        }
        if (index >= 0) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public JTextComponent getSelectedTextComponent() {
        Component comp;
        int row = this.getSelectedRow();
        int column = this.getSelectedColumn();
        if (row < 0 || column < 0) {
            return null;
        }
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor instanceof DefaultCellEditor && (comp = ((DefaultCellEditor)editor).getComponent()) instanceof JTextComponent) {
            return (JTextComponent)comp;
        }
        return null;
    }
}

