/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.util.Comparators;

public class EntityTreeModel
implements TreeModel {
    protected Entity root;
    protected Map sortedChildren;
    protected boolean hideAttributes;

    public EntityTreeModel(Entity root) {
        this.root = root;
        this.sortedChildren = Collections.synchronizedMap(new HashMap());
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isHideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(boolean hideAttributes) {
        this.hideAttributes = hideAttributes;
    }

    public Object getChild(Object node, int index) {
        return this.sortedChildren(node)[index];
    }

    public int getChildCount(Object node) {
        return node instanceof Attribute ? 0 : this.sortedChildren(node).length;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    public int getIndexOfChild(Object node, Object child) {
        if (node instanceof Attribute) {
            return -1;
        }
        return Arrays.binarySearch(this.sortedChildren(node), child, Comparators.getNamedObjectComparator());
    }

    public void addTreeModelListener(TreeModelListener listener) {
    }

    public void removeTreeModelListener(TreeModelListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] sortedChildren(Object node) {
        Entity entity = this.entityForNonLeafNode(node);
        if (entity == null) {
            return new Object[0];
        }
        Map map = this.sortedChildren;
        synchronized (map) {
            String key = entity.getName();
            Object[] sortedForNode = (Object[])this.sortedChildren.get(key);
            if (sortedForNode == null) {
                int i;
                Collection<? extends Attribute> attributes = entity.getAttributes();
                Collection<? extends Relationship> relationships = entity.getRelationships();
                int alen = this.hideAttributes ? 0 : attributes.size();
                int rlen = relationships.size();
                sortedForNode = new Object[alen + rlen];
                if (!this.hideAttributes) {
                    Iterator<? extends Attribute> ait = attributes.iterator();
                    for (i = 0; i < alen; ++i) {
                        sortedForNode[i] = ait.next();
                    }
                }
                Iterator<? extends Relationship> rit = relationships.iterator();
                for (i = 0; i < rlen; ++i) {
                    sortedForNode[alen + i] = rit.next();
                }
                Arrays.sort(sortedForNode, Comparators.getEntityChildrenComparator());
                this.sortedChildren.put(key, sortedForNode);
            }
            return sortedForNode;
        }
    }

    private Entity entityForNonLeafNode(Object node) {
        if (node instanceof Entity) {
            return (Entity)node;
        }
        if (node instanceof Relationship) {
            return ((Relationship)node).getTargetEntity();
        }
        String className = node != null ? node.getClass().getName() : "null";
        throw new IllegalArgumentException("Unexpected non-leaf node: " + className);
    }
}

