/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    public static void setProcedureParameterName(ProcedureParameter parameter, String newName) {
        String oldName = parameter.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        Procedure procedure = parameter.getProcedure();
        procedure.removeCallParameter(parameter.getName());
        parameter.setName(newName);
        procedure.addCallParameter(parameter);
    }

    public static void setDataMapName(DataDomain domain, DataMap map, String newName) {
        String oldName = map.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        ArrayList<DataNode> nodes = new ArrayList<DataNode>();
        for (DataNode node : domain.getDataNodes()) {
            if (!node.getDataMaps().contains(map)) continue;
            nodes.add(node);
        }
        domain.removeMap(oldName);
        map.setName(newName);
        domain.addMap(map);
        for (DataNode node : nodes) {
            node.removeDataMap(oldName);
            node.addDataMap(map);
        }
    }

    public static void setDataDomainName(Configuration configuration, DataDomain domain, String newName) {
        String oldName = domain.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        domain.setName(newName);
        configuration.removeDomain(oldName);
        configuration.addDomain(domain);
    }

    public static void setDataNodeName(DataDomain domain, DataNode node, String newName) {
        String oldName = node.getName();
        node.setName(newName);
        domain.removeDataNode(oldName);
        domain.addNode(node);
    }

    public static void setProcedureName(DataMap map, Procedure procedure, String newName) {
        String oldName = procedure.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        procedure.setName(newName);
        map.removeProcedure(oldName);
        map.addProcedure(procedure);
        MappingNamespace ns = map.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).clearCache();
        }
    }

    public static void setQueryName(DataMap map, AbstractQuery query, String newName) {
        String oldName = query.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        query.setName(newName);
        map.removeQuery(oldName);
        map.addQuery(query);
        MappingNamespace ns = map.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).clearCache();
        }
    }

    public static void setObjEntityName(DataMap map, ObjEntity entity, String newName) {
        String oldName = entity.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        entity.setName(newName);
        map.removeObjEntity(oldName, false);
        map.addObjEntity(entity);
        MappingNamespace ns = map.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).clearCache();
        }
    }

    public static void setDbEntityName(DbEntity entity, String newName) {
        String oldName = entity.getName();
        if (Util.nullSafeEquals(oldName, newName)) {
            return;
        }
        entity.setName(newName);
        DataMap map = entity.getDataMap();
        if (map != null) {
            map.removeDbEntity(oldName, false);
            map.addDbEntity(entity);
            MappingNamespace ns = map.getNamespace();
            if (ns instanceof EntityResolver) {
                ((EntityResolver)ns).clearCache();
            }
        }
    }

    public static void setAttributeName(Attribute attribute, String newName) {
        String oldName = attribute.getName();
        attribute.setName(newName);
        Entity entity = attribute.getEntity();
        if (entity != null) {
            entity.removeAttribute(oldName);
            entity.addAttribute(attribute);
        }
    }

    public static void setRelationshipName(Entity entity, Relationship rel, String newName) {
        if (rel == null || rel != entity.getRelationship(rel.getName())) {
            return;
        }
        entity.removeRelationship(rel.getName());
        rel.setName(newName);
        entity.addRelationship(rel);
    }

    public static void cleanObjMappings(DataMap map) {
        for (ObjEntity entity : map.getObjEntities()) {
            DbEntity dbEnt = entity.getDbEntity();
            if (dbEnt != null && map.getDbEntity(dbEnt.getName()) != dbEnt) {
                ProjectUtil.clearDbMapping(entity);
                continue;
            }
            for (ObjAttribute att : entity.getAttributes()) {
                DbAttribute dbAtt = att.getDbAttribute();
                if (dbAtt == null || dbEnt.getAttribute(dbAtt.getName()) == dbAtt) continue;
                att.setDbAttributePath(null);
            }
            for (ObjRelationship rel : entity.getRelationships()) {
                for (DbRelationship dbRel : new ArrayList<DbRelationship>(rel.getDbRelationships())) {
                    Entity srcEnt = dbRel.getSourceEntity();
                    if (srcEnt != null && map.getDbEntity(srcEnt.getName()) == srcEnt && srcEnt.getRelationship(dbRel.getName()) == dbRel) continue;
                    rel.removeDbRelationship(dbRel);
                }
            }
        }
    }

    public static void clearDbMapping(ObjEntity entity) {
        DbEntity db_entity = entity.getDbEntity();
        if (db_entity == null) {
            return;
        }
        for (ObjAttribute objAttr : entity.getAttributeMap().values()) {
            DbAttribute dbAttr = objAttr.getDbAttribute();
            if (null == dbAttr) continue;
            objAttr.setDbAttributePath(null);
        }
        for (ObjRelationship obj_rel : entity.getRelationships()) {
            obj_rel.clearDbRelationships();
        }
        entity.setDbEntity(null);
    }

    public static boolean containsSourceAttribute(DbRelationship relationship, DbAttribute attribute) {
        if (attribute.getEntity() != relationship.getSourceEntity()) {
            return false;
        }
        for (DbJoin join : relationship.getJoins()) {
            if (join.getSource() != attribute) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTargetAttribute(DbRelationship relationship, DbAttribute attribute) {
        if (attribute.getEntity() != relationship.getTargetEntity()) {
            return false;
        }
        for (DbJoin join : relationship.getJoins()) {
            if (join.getTarget() != attribute) continue;
            return true;
        }
        return false;
    }

    public static Collection<DbRelationship> getRelationshipsUsingAttributeAsSource(DbAttribute attribute) {
        Entity parent = attribute.getEntity();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<? extends Relationship> parentRelationships = parent.getRelationships();
        ArrayList<DbRelationship> relationships = new ArrayList<DbRelationship>(parentRelationships.size());
        for (DbRelationship dbRelationship : parentRelationships) {
            if (!ProjectUtil.containsSourceAttribute(dbRelationship, attribute)) continue;
            relationships.add(dbRelationship);
        }
        return relationships;
    }

    public static Collection<DbRelationship> getRelationshipsUsingAttributeAsTarget(DbAttribute attribute) {
        Entity parent = attribute.getEntity();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        DataMap map = parent.getDataMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DbRelationship> relationships = new ArrayList<DbRelationship>();
        for (Entity entity : map.getDbEntities()) {
            if (entity == parent) continue;
            Collection<? extends Relationship> entityRelationships = entity.getRelationships();
            for (DbRelationship dbRelationship : entityRelationships) {
                if (!ProjectUtil.containsTargetAttribute(dbRelationship, attribute)) continue;
                relationships.add(dbRelationship);
            }
        }
        return relationships;
    }
}

