/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

public class MergeDirection {
    private static final int TO_DB_ID = 1;
    private static final int TO_MODEL_ID = 2;
    public static final MergeDirection TO_DB = new MergeDirection(1, "To DB");
    public static final MergeDirection TO_MODEL = new MergeDirection(2, "To Model");
    private int id;
    private String name;

    private MergeDirection(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isToDb() {
        return this.id == 1;
    }

    public boolean isToModel() {
        return this.id == 2;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.id * 17;
    }

    public String toString() {
        return this.getName();
    }

    public MergeDirection reverseDirection() {
        switch (this.id) {
            case 1: {
                return TO_MODEL;
            }
            case 2: {
                return TO_DB;
            }
        }
        throw new IllegalStateException("Invalid direction id: " + this.id);
    }
}

