/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.trans.SelectTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataRowPostProcessor {
    private EntityInheritanceTree inheritanceTree;
    private Map<String, Collection<ColumnOverride>> columnOverrides;
    private Collection<ColumnOverride> defaultOverrides;

    static DataRowPostProcessor createPostProcessor(SelectTranslator translator) {
        Map attributeOverrides = translator.getAttributeOverrides();
        if (attributeOverrides.isEmpty()) {
            return null;
        }
        ColumnDescriptor[] columns = translator.getResultColumns();
        HashMap<String, Collection<ColumnOverride>> columnOverrides = new HashMap<String, Collection<ColumnOverride>>(2);
        for (Map.Entry entry : attributeOverrides.entrySet()) {
            ObjAttribute attribute = (ObjAttribute)entry.getKey();
            Entity entity = attribute.getEntity();
            String key = null;
            int jdbcType = Integer.MAX_VALUE;
            int index = -1;
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] != entry.getValue()) continue;
                if (attribute.getType().equals(columns[i].getJavaClass())) break;
                index = i + 1;
                jdbcType = columns[i].getJdbcType();
                key = columns[i].getLabel();
                break;
            }
            if (index < 1) continue;
            ExtendedType converter = translator.getAdapter().getExtendedTypes().getRegisteredType(attribute.getType());
            ArrayList<ColumnOverride> overrides = (ArrayList<ColumnOverride>)columnOverrides.get(entity.getName());
            if (overrides == null) {
                overrides = new ArrayList<ColumnOverride>(3);
                columnOverrides.put(entity.getName(), overrides);
            }
            overrides.add(new ColumnOverride(index, key, converter, jdbcType));
        }
        return columnOverrides.isEmpty() ? null : new DataRowPostProcessor(translator.getRootInheritanceTree(), columnOverrides);
    }

    private DataRowPostProcessor(EntityInheritanceTree inheritanceTree, Map<String, Collection<ColumnOverride>> columnOverrides) {
        if (inheritanceTree != null && inheritanceTree.getChildren().size() > 0) {
            this.inheritanceTree = inheritanceTree;
            this.columnOverrides = columnOverrides;
        } else {
            if (columnOverrides.size() != 1) {
                throw new IllegalArgumentException("No inheritance - there must be only one override set");
            }
            this.defaultOverrides = columnOverrides.values().iterator().next();
        }
    }

    void postprocessRow(ResultSet resultSet, DataRow row) throws Exception {
        Collection<ColumnOverride> overrides = this.getOverrides(row);
        if (overrides != null) {
            for (ColumnOverride override : overrides) {
                Object newValue = override.converter.materializeObject(resultSet, override.index, override.jdbcType);
                row.put(override.key, newValue);
            }
        }
    }

    private final Collection<ColumnOverride> getOverrides(DataRow row) {
        if (this.defaultOverrides != null) {
            return this.defaultOverrides;
        }
        ObjEntity entity = this.inheritanceTree.entityMatchingRow(row);
        return entity != null ? this.columnOverrides.get(entity.getName()) : null;
    }

    static final class ColumnOverride {
        int index;
        int jdbcType;
        String key;
        ExtendedType converter;

        ColumnOverride(int index, String key, ExtendedType converter, int jdbcType) {
            this.index = index;
            this.key = key;
            this.converter = converter;
            this.jdbcType = jdbcType;
        }
    }
}

