/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import org.apache.cayenne.access.jdbc.EJBQLJoinAppender;
import org.apache.cayenne.access.jdbc.EJBQLTableId;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.EJBQLFromItem;
import org.apache.cayenne.ejbql.parser.EJBQLJoin;

public class EJBQLFromTranslator
extends EJBQLBaseVisitor {
    protected EJBQLTranslationContext context;
    private String lastId;
    private EJBQLJoinAppender joinAppender;

    public EJBQLFromTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
        this.joinAppender = context.getTranslatorFactory().getJoinAppender(context);
    }

    public boolean visitFrom(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex + 1 == expression.getChildrenCount() && this.lastId != null) {
            this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(this.lastId));
        }
        return true;
    }

    public boolean visitFromItem(EJBQLFromItem expression, int finishedChildIndex) {
        String id = expression.getId();
        if (this.lastId != null) {
            this.context.append(',');
            this.context.markCurrentPosition(EJBQLJoinAppender.makeJoinTailMarker(this.lastId));
        }
        this.lastId = id;
        this.joinAppender.appendTable(new EJBQLTableId(id));
        return false;
    }

    public boolean visitInnerFetchJoin(EJBQLJoin join) {
        throw new UnsupportedOperationException("Fetch joins are not yet supported");
    }

    public boolean visitInnerJoin(EJBQLJoin join) {
        this.joinAppender.appendInnerJoin(null, new EJBQLTableId(join.getLeftHandSideId()), new EJBQLTableId(join.getRightHandSideId()));
        return false;
    }

    public boolean visitOuterFetchJoin(EJBQLJoin join) {
        throw new UnsupportedOperationException("Fetch joins are not yet supported");
    }

    public boolean visitOuterJoin(EJBQLJoin join) {
        this.joinAppender.appendOuterJoin(null, new EJBQLTableId(join.getLeftHandSideId()), new EJBQLTableId(join.getRightHandSideId()));
        return false;
    }
}

