/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.trans.SelectTranslator;
import org.apache.cayenne.access.util.DistinctResultIterator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;

public class SelectAction
extends BaseSQLAction {
    protected SelectQuery query;

    public SelectAction(SelectQuery query, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = query;
    }

    protected SelectTranslator createTranslator(Connection connection) {
        SelectTranslator translator = new SelectTranslator();
        translator.setQuery(this.query);
        translator.setAdapter(this.adapter);
        translator.setEntityResolver(this.getEntityResolver());
        translator.setConnection(connection);
        return translator;
    }

    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        SelectTranslator translator = this.createTranslator(connection);
        PreparedStatement prepStmt = translator.createStatement();
        ResultSet rs = prepStmt.executeQuery();
        RowDescriptor descriptor = new RowDescriptorBuilder().setColumns(translator.getResultColumns()).getDescriptor(this.getAdapter().getExtendedTypes());
        JDBCResultIterator workerIterator = new JDBCResultIterator(connection, prepStmt, rs, descriptor, this.query.getFetchLimit());
        workerIterator.setPostProcessor(DataRowPostProcessor.createPostProcessor(translator));
        ResultIterator it = workerIterator;
        if (translator.isSuppressingDistinct()) {
            final boolean[] compareFullRows = new boolean[1];
            QueryMetadata md = this.query.getMetaData(this.getEntityResolver());
            final PrefetchTreeNode rootPrefetch = md.getPrefetchTree();
            if (rootPrefetch != null) {
                rootPrefetch.traverse(new PrefetchProcessor(){

                    public void finishPrefetch(PrefetchTreeNode node) {
                    }

                    public boolean startDisjointPrefetch(PrefetchTreeNode node) {
                        return rootPrefetch == node;
                    }

                    public boolean startUnknownPrefetch(PrefetchTreeNode node) {
                        return rootPrefetch == node;
                    }

                    public boolean startJointPrefetch(PrefetchTreeNode node) {
                        if (rootPrefetch != node) {
                            compareFullRows[0] = true;
                            return false;
                        }
                        return true;
                    }

                    public boolean startPhantomPrefetch(PrefetchTreeNode node) {
                        return true;
                    }
                });
            }
            it = new DistinctResultIterator(workerIterator, translator.getRootDbEntity(), compareFullRows[0]);
        }
        if (!observer.isIteratedResult()) {
            List<DataRow> resultRows = it.dataRows(true);
            QueryLogger.logSelectCount(resultRows.size(), System.currentTimeMillis() - t1);
            observer.nextDataRows((Query)this.query, resultRows);
        } else {
            try {
                workerIterator.setClosingConnection(true);
                observer.nextDataRows(translator.getQuery(), it);
            }
            catch (Exception ex) {
                it.close();
                throw ex;
            }
        }
    }
}

