/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.PreparedStatement;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.trans.SelectTranslator;
import org.apache.cayenne.query.QueryMetadata;

public class OracleSelectTranslator
extends SelectTranslator {
    public String createSqlString() throws Exception {
        String sqlString = super.createSqlString();
        QueryMetadata info = this.getQuery().getMetaData(this.getEntityResolver());
        if (info.getFetchLimit() > 0) {
            sqlString = "SELECT * FROM (" + sqlString + ") WHERE rownum <= " + info.getFetchLimit();
        }
        return sqlString;
    }

    public PreparedStatement createStatement() throws Exception {
        String sqlStr = this.createSqlString();
        QueryLogger.logQuery(sqlStr, this.values);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }
}

