/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.SecondaryTable;
import org.apache.cayenne.jpa.map.JpaPrimaryKeyJoinColumn;
import org.apache.cayenne.jpa.map.JpaTable;
import org.apache.cayenne.jpa.map.JpaUniqueConstraint;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaSecondaryTable
extends JpaTable {
    protected Collection<JpaPrimaryKeyJoinColumn> primaryKeyJoinColumns;

    public JpaSecondaryTable() {
    }

    public JpaSecondaryTable(SecondaryTable annotation) {
        int i;
        if (!"".equals(annotation.name())) {
            this.name = annotation.name();
        }
        if (!"".equals(annotation.catalog())) {
            this.catalog = annotation.catalog();
        }
        if (!"".equals(annotation.schema())) {
            this.schema = annotation.schema();
        }
        this.getUniqueConstraints();
        for (i = 0; i < annotation.uniqueConstraints().length; ++i) {
            this.uniqueConstraints.add(new JpaUniqueConstraint(annotation.uniqueConstraints()[i]));
        }
        this.getPrimaryKeyJoinColumns();
        for (i = 0; i < annotation.pkJoinColumns().length; ++i) {
            this.primaryKeyJoinColumns.add(new JpaPrimaryKeyJoinColumn(annotation.pkJoinColumns()[i]));
        }
    }

    @TreeNodeChild(type=JpaPrimaryKeyJoinColumn.class)
    public Collection<JpaPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        if (this.primaryKeyJoinColumns == null) {
            this.primaryKeyJoinColumns = new ArrayList<JpaPrimaryKeyJoinColumn>();
        }
        return this.primaryKeyJoinColumns;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<secondary-table");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        if (this.catalog != null) {
            encoder.print(" catalog=\"" + this.catalog + "\"");
        }
        if (this.schema != null) {
            encoder.print(" schema=\"" + this.schema + "\"");
        }
        encoder.println('>');
        encoder.indent(1);
        if (this.primaryKeyJoinColumns != null) {
            encoder.print(this.primaryKeyJoinColumns);
        }
        encoder.indent(-1);
        encoder.println("</secondary-table>");
    }
}

