/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.AboutAction;
import org.apache.cayenne.modeler.action.ConfigurePreferencesAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodForDataMapListenerAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateDomainAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateObjEntityListenerAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.DocumentationAction;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.action.GenerateCodeAction;
import org.apache.cayenne.modeler.action.GenerateDBAction;
import org.apache.cayenne.modeler.action.ImportDBAction;
import org.apache.cayenne.modeler.action.ImportDataMapAction;
import org.apache.cayenne.modeler.action.ImportEOModelAction;
import org.apache.cayenne.modeler.action.MigrateAction;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodForDataMapListenerAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerForDataMapAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.util.CayenneAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager {
    static final Collection<String> SPECIAL_ACTIONS = Arrays.asList(SaveAction.getActionName());
    static final Collection<String> PROJECT_ACTIONS = Arrays.asList(RevertAction.getActionName(), CreateDomainAction.getActionName(), ProjectAction.getActionName(), ValidateAction.getActionName(), SaveAsAction.getActionName(), FindAction.getActionName());
    static final Collection<String> DOMAIN_ACTIONS = new HashSet<String>(PROJECT_ACTIONS);
    static final Collection<String> DATA_MAP_ACTIONS;
    static final Collection<String> OBJ_ENTITY_ACTIONS;
    static final Collection<String> DB_ENTITY_ACTIONS;
    static final Collection<String> PROCEDURE_ACTIONS;
    protected Map<String, Action> actionMap = new HashMap<String, Action>(40);

    public ActionManager(Application application) {
        this.registerAction(new ProjectAction(application));
        this.registerAction(new NewProjectAction(application)).setAlwaysOn(true);
        this.registerAction(new OpenProjectAction(application)).setAlwaysOn(true);
        this.registerAction(new ImportDataMapAction(application));
        this.registerAction(new SaveAction(application));
        this.registerAction(new SaveAsAction(application));
        this.registerAction(new RevertAction(application));
        this.registerAction(new ValidateAction(application));
        this.registerAction(new RemoveAction(application));
        this.registerAction(new CreateDomainAction(application));
        this.registerAction(new CreateNodeAction(application));
        this.registerAction(new CreateDataMapAction(application));
        this.registerAction(new GenerateCodeAction(application));
        this.registerAction(new CreateObjEntityAction(application));
        this.registerAction(new CreateDbEntityAction(application));
        this.registerAction(new CreateProcedureAction(application));
        this.registerAction(new CreateProcedureParameterAction(application));
        this.registerAction(new RemoveProcedureParameterAction(application));
        this.registerAction(new CreateQueryAction(application));
        this.registerAction(new CreateAttributeAction(application));
        this.registerAction(new RemoveAttributeAction(application));
        this.registerAction(new CreateRelationshipAction(application));
        this.registerAction(new RemoveRelationshipAction(application));
        this.registerAction(new CreateCallbackMethodAction(application)).setAlwaysOn(true);
        this.registerAction(new CreateCallbackMethodForListenerAction(application));
        this.registerAction(new CreateCallbackMethodForDataMapListenerAction(application));
        this.registerAction(new RemoveCallbackMethodAction(application));
        this.registerAction(new RemoveCallbackMethodForListenerAction(application));
        this.registerAction(new RemoveCallbackMethodForDataMapListenerAction(application));
        this.registerAction(new CreateObjEntityListenerAction(application)).setAlwaysOn(true);
        this.registerAction(new CreateDataMapEntityListenerAction(application)).setAlwaysOn(true);
        this.registerAction(new RemoveEntityListenerAction(application));
        this.registerAction(new RemoveEntityListenerForDataMapAction(application));
        this.registerAction(new DbEntitySyncAction(application));
        this.registerAction(new ObjEntitySyncAction(application));
        this.registerAction(new ImportDBAction(application));
        this.registerAction(new ImportEOModelAction(application));
        this.registerAction(new GenerateDBAction(application));
        this.registerAction(new MigrateAction(application));
        this.registerAction(new AboutAction(application)).setAlwaysOn(true);
        this.registerAction(new DocumentationAction(application)).setAlwaysOn(true);
        this.registerAction(new ConfigurePreferencesAction(application)).setAlwaysOn(true);
        this.registerAction(new ExitAction(application)).setAlwaysOn(true);
        this.registerAction(new NavigateBackwardAction(application)).setAlwaysOn(true);
        this.registerAction(new NavigateForwardAction(application)).setAlwaysOn(true);
        this.registerAction(new FindAction(application));
    }

    private CayenneAction registerAction(CayenneAction action) {
        this.actionMap.put(action.getKey(), action);
        return action;
    }

    public CayenneAction getAction(String key) {
        return (CayenneAction)this.actionMap.get(key);
    }

    public void projectOpened() {
        this.processActionsState(PROJECT_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove");
    }

    public void projectClosed() {
        this.processActionsState(Collections.EMPTY_SET);
        this.getAction(RemoveAction.getActionName()).setName("Remove");
    }

    public void domainSelected() {
        this.processActionsState(DOMAIN_ACTIONS);
    }

    public void dataNodeSelected() {
        this.processActionsState(DOMAIN_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove DataNode");
    }

    public void dataMapSelected() {
        this.processActionsState(DATA_MAP_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove DataMap");
    }

    public void objEntitySelected() {
        this.processActionsState(OBJ_ENTITY_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove ObjEntity");
    }

    public void dbEntitySelected() {
        this.processActionsState(DB_ENTITY_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove DbEntity");
    }

    public void derivedDbEntitySelected() {
        this.processActionsState(DB_ENTITY_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove Derived DbEntity");
    }

    public void procedureSelected() {
        this.processActionsState(PROCEDURE_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove Procedure");
    }

    public void querySelected() {
        this.processActionsState(DATA_MAP_ACTIONS);
        this.getAction(RemoveAction.getActionName()).setName("Remove Query");
    }

    protected void processActionsState(Collection<String> namesOfEnabled) {
        for (Map.Entry<String, Action> entry : this.actionMap.entrySet()) {
            if (SPECIAL_ACTIONS.contains(entry.getKey())) continue;
            entry.getValue().setEnabled(namesOfEnabled.contains(entry.getKey()));
        }
    }

    static {
        DOMAIN_ACTIONS.addAll(Arrays.asList(ImportDataMapAction.getActionName(), CreateDataMapAction.getActionName(), RemoveAction.getActionName(), CreateNodeAction.getActionName(), ImportDBAction.getActionName(), ImportEOModelAction.getActionName()));
        DATA_MAP_ACTIONS = new HashSet<String>(DOMAIN_ACTIONS);
        DATA_MAP_ACTIONS.addAll(Arrays.asList(GenerateCodeAction.getActionName(), CreateObjEntityAction.getActionName(), CreateDbEntityAction.getActionName(), CreateQueryAction.getActionName(), CreateProcedureAction.getActionName(), GenerateDBAction.getActionName(), MigrateAction.getActionName()));
        OBJ_ENTITY_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        OBJ_ENTITY_ACTIONS.addAll(Arrays.asList(ObjEntitySyncAction.getActionName(), CreateAttributeAction.getActionName(), CreateRelationshipAction.getActionName()));
        DB_ENTITY_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        DB_ENTITY_ACTIONS.addAll(Arrays.asList(CreateAttributeAction.getActionName(), CreateRelationshipAction.getActionName(), DbEntitySyncAction.getActionName()));
        PROCEDURE_ACTIONS = new HashSet<String>(DATA_MAP_ACTIONS);
        PROCEDURE_ACTIONS.addAll(Arrays.asList(CreateProcedureParameterAction.getActionName()));
    }
}

