/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.ActionManager;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.FileClassLoadingService;
import org.apache.cayenne.modeler.util.AdapterMapping;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.DomainPreference;
import org.apache.cayenne.pref.HSQLEmbeddedPreferenceEditor;
import org.apache.cayenne.pref.HSQLEmbeddedPreferenceService;
import org.apache.cayenne.pref.PreferenceService;
import org.apache.cayenne.project.CayenneUserDir;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.swing.BindingFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.scopemvc.controller.basic.ViewContext;
import org.scopemvc.controller.swing.SwingContext;
import org.scopemvc.core.View;
import org.scopemvc.util.UIStrings;
import org.scopemvc.view.swing.SwingView;

public class Application {
    public static final String PREFERENCES_VERSION = "1.2";
    public static final String PREFERENCES_DB_SUBDIRECTORY = "prefs";
    public static final String PREFERENCES_MAP_PACKAGE = "pref";
    public static final String APPLICATION_NAME_PROPERTY = "cayenne.modeler.application.name";
    public static final String PREFERENCES_VERSION_PROPERTY = "cayenne.modeler.pref.version";
    public static final String DEFAULT_APPLICATION_NAME = "CayenneModeler";
    protected static Application instance;
    protected FileClassLoadingService modelerClassLoader;
    protected HSQLEmbeddedPreferenceService preferenceService;
    protected ActionManager actionManager;
    protected CayenneModelerController frameController;
    protected File initialProject;
    protected String name;
    protected String preferencesDB;
    protected BindingFactory bindingFactory;
    protected AdapterMapping adapterMapping;
    private boolean isQuittingApplication = false;

    public static Application getInstance() {
        return instance;
    }

    public static CayenneModelerFrame getFrame() {
        return (CayenneModelerFrame)Application.getInstance().getFrameController().getView();
    }

    public static Project getProject() {
        return Application.getInstance().getFrameController().getProjectController().getProject();
    }

    public Application(File initialProject) {
        this.initialProject = initialProject;
        String configuredName = System.getProperty(APPLICATION_NAME_PROPERTY);
        this.name = configuredName != null ? configuredName : DEFAULT_APPLICATION_NAME;
        String subdir = System.getProperty(PREFERENCES_VERSION_PROPERTY);
        if (subdir == null) {
            subdir = PREFERENCES_VERSION;
        }
        File dbDir = new File(CayenneUserDir.getInstance().resolveFile(PREFERENCES_DB_SUBDIRECTORY), subdir);
        dbDir.mkdirs();
        this.preferencesDB = new File(dbDir, "db").getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public ClassLoadingService getClassLoadingService() {
        return this.modelerClassLoader;
    }

    public AdapterMapping getAdapterMapping() {
        return this.adapterMapping;
    }

    public CayenneAction getAction(String key) {
        return this.getActionManager().getAction(key);
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public CayenneModelerController getFrameController() {
        return this.frameController;
    }

    public void startup() {
        this.initPreferences();
        this.initClassLoader();
        this.bindingFactory = new BindingFactory();
        this.adapterMapping = new AdapterMapping();
        UIStrings.setPropertiesName((String)"org.apache.cayenne.modeler.cayennemodeler-strings");
        ViewContext.clearThreadContext();
        this.actionManager = new ActionManager(this);
        this.frameController = new CayenneModelerController(this, this.initialProject);
        ViewContext.setGlobalContext((ViewContext)new ModelerContext(this.frameController.getFrame()));
        this.frameController.startupAction();
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public PreferenceService getPreferenceService() {
        return this.preferenceService;
    }

    public Domain getPreferenceDomain() {
        return this.getPreferenceService().getDomain(this.getName(), true);
    }

    public CodeTemplateManager getCodeTemplateManager() {
        return new CodeTemplateManager(this);
    }

    public void initClassLoader() {
        final FileClassLoadingService classLoader = new FileClassLoadingService();
        Domain classLoaderDomain = this.getPreferenceDomain().getSubdomain(FileClassLoadingService.class);
        List details = classLoaderDomain.getPreferences();
        if (details.size() > 0) {
            Transformer transformer = new Transformer(){

                public Object transform(Object object) {
                    DomainPreference pref = (DomainPreference)((Object)object);
                    return new File(pref.getKey());
                }
            };
            classLoader.setPathFiles(CollectionUtils.collect((Collection)details, (Transformer)transformer));
        }
        this.modelerClassLoader = classLoader;
        if (SwingUtilities.isEventDispatchThread()) {
            Thread.currentThread().setContextClassLoader(classLoader.getClassLoader());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(classLoader.getClassLoader());
                }
            });
        }
    }

    protected void initPreferences() {
        HSQLEmbeddedPreferenceService service = new HSQLEmbeddedPreferenceService(this.preferencesDB, PREFERENCES_MAP_PACKAGE, this.getName());
        service.stopOnShutdown();
        this.preferenceService = service;
        this.preferenceService.startService();
        this.getPreferenceDomain();
    }

    public boolean isQuittingApplication() {
        return this.isQuittingApplication;
    }

    public void setQuittingApplication(boolean isQuittingApplication) {
        this.isQuittingApplication = isQuittingApplication;
    }

    final class ModelerContext
    extends SwingContext {
        JFrame frame;

        public ModelerContext(JFrame frame) {
            this.frame = frame;
        }

        protected void showViewInPrimaryWindow(SwingView view) {
        }

        protected void showViewInDialog(SwingView inView) {
            Window parentWindow = this.getDefaultParentWindow();
            CayenneDialog dialog = parentWindow instanceof Dialog ? new CayenneDialog((Dialog)parentWindow) : new CayenneDialog((Frame)parentWindow);
            if (inView.getTitle() != null) {
                dialog.setTitle(inView.getTitle());
            }
            if (inView.getDisplayMode() == 1) {
                dialog.setModal(true);
            } else {
                dialog.setModal(false);
            }
            dialog.setResizable(inView.isResizable());
            this.setupWindow(dialog.getRootPane(), inView, true);
            dialog.toFront();
        }

        public JRootPane findRootPaneFor(View view) {
            JRootPane pane = super.findRootPaneFor(view);
            if (pane != null) {
                return pane;
            }
            if (((SwingView)view).getDisplayMode() != 0) {
                return pane;
            }
            return this.frame.getRootPane();
        }

        protected Window getDefaultParentWindow() {
            return this.frame;
        }
    }

    static final class PreferencesDelegate
    implements HSQLEmbeddedPreferenceEditor.Delegate {
        static final String message = "Preferences Database is locked by another application. Do you want to remove the lock?";
        static final String failureMessage = "Failed to remove database lock. Preferences will we saved for this session only.";
        static final HSQLEmbeddedPreferenceEditor.Delegate sharedInstance = new PreferencesDelegate();

        PreferencesDelegate() {
        }

        public boolean deleteMasterLock(File lock) {
            int result = JOptionPane.showConfirmDialog(null, message);
            if (!(result != 0 && result != 0 || lock.delete())) {
                JOptionPane.showMessageDialog(null, failureMessage);
                return false;
            }
            return true;
        }
    }
}

