/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.modeler.ClassLoadingService;

public class FileClassLoadingService
implements ClassLoadingService {
    private FileClassLoader classLoader;
    protected List pathFiles = new ArrayList(15);

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        return this.nonNullClassLoader().loadClass(className);
    }

    public ClassLoader getClassLoader() {
        return this.nonNullClassLoader();
    }

    public synchronized List getPathFiles() {
        return Collections.unmodifiableList(this.pathFiles);
    }

    public synchronized void setPathFiles(Collection files) {
        this.pathFiles.clear();
        this.classLoader = null;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            this.addFile((File)it.next());
        }
    }

    private void addFile(File file) {
        if (this.pathFiles.contains(file = file.getAbsoluteFile())) {
            return;
        }
        if (this.classLoader != null) {
            try {
                this.classLoader.addURL(file.toURL());
            }
            catch (MalformedURLException ex) {
                return;
            }
        }
        this.pathFiles.add(file);
    }

    private synchronized FileClassLoader nonNullClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new FileClassLoader(this.getClass().getClassLoader(), this.pathFiles);
        }
        return this.classLoader;
    }

    static class FileClassLoader
    extends URLClassLoader {
        FileClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        FileClassLoader(ClassLoader parent, List files) {
            this(parent);
            for (File file : files) {
                try {
                    this.addURL(file.toURL());
                }
                catch (MalformedURLException ex) {}
            }
        }

        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

