/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ModelerDbAdapter;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.cayenne.project.ProjectPath;

public class CreateNodeAction
extends CayenneAction {
    public static String getActionName() {
        return "Create DataNode";
    }

    public CreateNodeAction(Application application) {
        super(CreateNodeAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-node.gif";
    }

    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DataDomain domain = mediator.getCurrentDataDomain();
        DataNode node = this.buildDataNode();
        mediator.fireDataNodeEvent(new DataNodeEvent((Object)this, node, 2));
        mediator.fireDataNodeDisplayEvent(new DataNodeDisplayEvent(this, domain, node));
    }

    protected DataNode buildDataNode() {
        ProjectController mediator = this.getProjectController();
        DataDomain domain = mediator.getCurrentDataDomain();
        DataNode node = this.createDataNode(domain);
        ProjectDataSource src = new ProjectDataSource(new DataSourceInfo());
        node.setDataSource((DataSource)src);
        node.setAdapter((DbAdapter)new ModelerDbAdapter((DataSource)src));
        node.setDataSourceFactory(DriverDataSourceFactory.class.getName());
        domain.addNode(node);
        return node;
    }

    protected DataNode createDataNode(DataDomain domain) {
        String name = NamedObjectFactory.createName(DataNode.class, (Object)domain, (String)(domain.getName() + "Node"));
        return new DataNode(name){

            public DataSource getDataSource() {
                return this.dataSource;
            }
        };
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataDomain.class) != null;
    }
}

