/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.ProjectPath;

public class RemoveAttributeAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove Attribute";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public RemoveAttributeAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.getObject() instanceof Attribute;
    }

    public void performAction(ActionEvent e) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog();
        if (this.getProjectController().getCurrentObjAttribute() != null) {
            if (dialog.shouldDelete("ObjAttribute", this.getProjectController().getCurrentObjAttribute().getName())) {
                this.removeObjAttribute();
            }
        } else if (this.getProjectController().getCurrentDbAttribute() != null && dialog.shouldDelete("DbAttribute", this.getProjectController().getCurrentDbAttribute().getName())) {
            this.removeDbAttribute();
        }
    }

    protected void removeDbAttribute() {
        ProjectController mediator = this.getProjectController();
        DbEntity entity = mediator.getCurrentDbEntity();
        DbAttribute attrib = mediator.getCurrentDbAttribute();
        entity.removeAttribute(attrib.getName());
        ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
        AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
        mediator.fireDbAttributeEvent(e);
    }

    protected void removeObjAttribute() {
        ProjectController mediator = this.getProjectController();
        ObjEntity entity = mediator.getCurrentObjEntity();
        ObjAttribute attrib = mediator.getCurrentObjAttribute();
        entity.removeAttribute(attrib.getName());
        AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
        mediator.fireObjAttributeEvent(e);
    }
}

