/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.event.EntityListenerEvent;

public class RemoveEntityListenerForDataMapAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove entity listener for data map";

    public RemoveEntityListenerForDataMapAction(Application application) {
        super(RemoveEntityListenerForDataMapAction.getActionName(), application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getIconName() {
        return "icon-remove-listener.gif";
    }

    public void performAction(ActionEvent e) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog();
        if (this.getProjectController().getCurrentListenerClass() != null && dialog.shouldDelete("entity listener", this.getProjectController().getCurrentListenerClass())) {
            this.removeDefaultEntityListener();
        }
    }

    protected void removeDefaultEntityListener() {
        String listenerClass = this.getProjectController().getCurrentListenerClass();
        if (listenerClass != null) {
            this.getProjectController().getCurrentDataMap().removeDefaultEntityListener(listenerClass);
            this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(this, listenerClass, listenerClass, 3));
        }
    }
}

