/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.KeyStroke;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.ProjectOpener;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.Validator;

public class SaveAsAction
extends CayenneAction {
    protected ProjectOpener fileChooser = new ProjectOpener();

    public static String getActionName() {
        return "Save As...";
    }

    public SaveAsAction(Application application) {
        this(SaveAsAction.getActionName(), application);
    }

    protected SaveAsAction(String name, Application application) {
        super(name, application);
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
    }

    protected boolean saveAll() throws Exception {
        Project p = this.getCurrentProject();
        Domain preference = this.getProjectController().getPreferenceDomainForProject();
        if (!this.chooseDestination(p)) {
            return false;
        }
        p.save();
        preference.rename(p.getMainFile().getAbsolutePath());
        this.getApplication().getFrameController().addToLastProjListAction(p.getMainFile().getAbsolutePath());
        return true;
    }

    protected boolean chooseDestination(Project p) {
        File projectDir = this.fileChooser.newProjectDir(Application.getFrame(), p);
        if (projectDir == null) {
            return false;
        }
        p.setProjectDirectory(projectDir);
        return true;
    }

    public synchronized void performAction(ActionEvent e) {
        this.performAction(1);
    }

    public synchronized void performAction(int warningLevel) {
        Validator val = this.getCurrentProject().getValidator();
        int validationCode = val.validate();
        if (validationCode < 2) {
            try {
                if (!this.saveAll()) {
                    return;
                }
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error on save", (Throwable)ex);
            }
            this.getApplication().getFrameController().projectSavedAction();
        }
        if (validationCode >= warningLevel) {
            ValidatorDialog.showDialog(Application.getFrame(), val);
        }
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        Project project = (Project)path.firstInstanceOf(Project.class);
        return project != null && project.isModified();
    }
}

