/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.pref.PreferenceDetail;

public class ConfirmRemoveDialog {
    private boolean shouldDelete = true;

    private void showDialog(String type, String name) {
        JCheckBox neverPromptAgainBox = new JCheckBox("Always delete without prompt.");
        Object[] message = new Object[]{String.format("Are you sure you would like to delete the %s named '%s'?", type, name), neverPromptAgainBox};
        JOptionPane pane = new JOptionPane(message, 3, 0);
        JDialog dialog = pane.createDialog(Application.getFrame(), "File exists");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        this.shouldDelete = selectedValue.equals(0);
        if (this.shouldDelete) {
            PreferenceDetail pref = Application.getInstance().getPreferenceDomain().getDetail("deletePrompt", true);
            pref.setBooleanProperty("deletePrompt", neverPromptAgainBox.isSelected());
            Application.getInstance().getPreferenceService().savePreferences();
        }
    }

    public boolean shouldDelete(String type, String name) {
        PreferenceDetail pref = Application.getInstance().getPreferenceDomain().getDetail("deletePrompt", true);
        if (pref == null || !pref.getBooleanProperty("deletePrompt")) {
            this.showDialog(type, name);
        }
        return this.shouldDelete;
    }
}

