/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClassGenerationAction1_1;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.CustomModePanel;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;

public class CustomModeController
extends GeneratorController {
    static final String MODE_DATAMAP = "datamap";
    static final String MODE_ENTITY = "entity";
    static final String DATA_MAP_MODE_LABEL = "One run per DataMap";
    static final String ENTITY_MODE_LABEL = "One run per each selected Entity";
    static final Map<String, String> modesByLabel = new HashMap<String, String>();
    protected CustomModePanel view;
    protected CodeTemplateManager templateManager;
    protected ObjectBinding superTemplate;
    protected ObjectBinding subTemplate;

    public CustomModeController(CodeGeneratorControllerBase parent) {
        super(parent);
        Object[] modeChoices = new Object[]{ENTITY_MODE_LABEL, DATA_MAP_MODE_LABEL};
        this.view.getGenerationMode().setModel(new DefaultComboBoxModel<Object>(modeChoices));
        Object[] versionChoices = new Object[]{"1.2", "1.1"};
        this.view.getGeneratorVersion().setModel(new DefaultComboBoxModel<Object>(versionChoices));
        if (Util.isEmptyString((String)this.preferences.getSuperclassTemplate())) {
            this.preferences.setSuperclassTemplate("Standard Server Superclass");
        }
        if (Util.isEmptyString((String)this.preferences.getSubclassTemplate())) {
            this.preferences.setSubclassTemplate("Standard Server Subclass");
        }
        if (Util.isEmptyString((String)this.preferences.getProperty("mode"))) {
            this.preferences.setProperty("mode", MODE_ENTITY);
        }
        if (Util.isEmptyString((String)this.preferences.getProperty("version"))) {
            this.preferences.setProperty("version", "1.2");
        }
        if (Util.isEmptyString((String)this.preferences.getProperty("overwrite"))) {
            this.preferences.setBooleanProperty("overwrite", false);
        }
        if (Util.isEmptyString((String)this.preferences.getProperty("pairs"))) {
            this.preferences.setBooleanProperty("pairs", true);
        }
        if (Util.isEmptyString((String)this.preferences.getProperty("usePackagePath"))) {
            this.preferences.setBooleanProperty("usePackagePath", true);
        }
        if (Util.isEmptyString((String)this.preferences.getProperty("outputPattern"))) {
            this.preferences.setProperty("outputPattern", "*.java");
        }
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getManageTemplatesLink(), "popPreferencesAction()");
        builder.bindToTextField(this.view.getSuperclassPackage(), "preferences.superclassPackage").updateView();
        builder.bindToComboSelection(this.view.getGenerationMode(), "preferences.property['mode']").updateView();
        builder.bindToComboSelection(this.view.getGeneratorVersion(), "preferences.property['version']").updateView();
        builder.bindToStateChange(this.view.getOverwrite(), "preferences.booleanProperty['overwrite']").updateView();
        builder.bindToStateChange(this.view.getPairs(), "preferences.booleanProperty['pairs']").updateView();
        builder.bindToStateChange(this.view.getUsePackagePath(), "preferences.booleanProperty['usePackagePath']").updateView();
        this.subTemplate = builder.bindToComboSelection(this.view.getSubclassTemplate(), "preferences.subclassTemplate");
        this.superTemplate = builder.bindToComboSelection(this.view.getSuperclassTemplate(), "preferences.superclassTemplate");
        builder.bindToTextField(this.view.getOutputPattern(), "preferences.property['outputPattern']").updateView();
        this.updateTemplates();
    }

    protected DataMapDefaults createDefaults() {
        DataMapDefaults prefs = this.getApplication().getFrameController().getProjectController().getDataMapPreferences("__custom");
        prefs.updateSuperclassPackage(this.getParentController().getDataMap(), false);
        this.preferences = prefs;
        return prefs;
    }

    protected void updateTemplates() {
        this.templateManager = this.getApplication().getCodeTemplateManager();
        ArrayList<String> customTemplates = new ArrayList<String>(this.templateManager.getCustomTemplates().keySet());
        Collections.sort(customTemplates);
        ArrayList<String> superTemplates = new ArrayList<String>(this.templateManager.getStandardSuperclassTemplates());
        Collections.sort(superTemplates);
        superTemplates.addAll(customTemplates);
        ArrayList<String> subTemplates = new ArrayList<String>(this.templateManager.getStandardSubclassTemplates());
        Collections.sort(subTemplates);
        subTemplates.addAll(customTemplates);
        this.view.getSubclassTemplate().setModel(new DefaultComboBoxModel<Object>(subTemplates.toArray()));
        this.view.getSuperclassTemplate().setModel(new DefaultComboBoxModel<Object>(superTemplates.toArray()));
        this.superTemplate.updateView();
        this.subTemplate.updateView();
    }

    protected GeneratorControllerPanel createView() {
        this.view = new CustomModePanel();
        return this.view;
    }

    public Component getView() {
        return this.view;
    }

    private String getVersion() {
        return (String)this.view.getGeneratorVersion().getSelectedItem();
    }

    protected ClassGenerationAction newGenerator() {
        return "1.1".equals(this.getVersion()) ? new ClassGenerationAction1_1() : new ClassGenerationAction();
    }

    public ClassGenerationAction createGenerator() {
        ClassGenerationAction generator = super.createGenerator();
        String mode = modesByLabel.get(this.view.getGenerationMode().getSelectedItem()).toString();
        generator.setArtifactsGenerationMode(mode);
        String version = this.getVersion();
        String superKey = this.view.getSuperclassTemplate().getSelectedItem().toString();
        String superTemplate = this.templateManager.getTemplatePath(superKey, version);
        generator.setSuperTemplate(superTemplate);
        String subKey = this.view.getSubclassTemplate().getSelectedItem().toString();
        String subTemplate = this.templateManager.getTemplatePath(subKey, version);
        generator.setTemplate(subTemplate);
        generator.setOverwrite(this.view.getOverwrite().isSelected());
        generator.setUsePkgPath(this.view.getUsePackagePath().isSelected());
        generator.setMakePairs(this.view.getPairs().isSelected());
        if (!Util.isEmptyString((String)this.view.getOutputPattern().getText())) {
            generator.setOutputPattern(this.view.getOutputPattern().getText());
        }
        return generator;
    }

    public void popPreferencesAction() {
        new PreferenceDialog(this.getApplication().getFrameController()).startupAction("Templates");
        this.updateTemplates();
    }

    static {
        modesByLabel.put(DATA_MAP_MODE_LABEL, MODE_DATAMAP);
        modesByLabel.put(ENTITY_MODE_LABEL, MODE_ENTITY);
    }
}

