/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.awt.Component;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.LockingUpdateDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;

public class LockingUpdateController
extends CayenneController {
    protected LockingUpdateDialog view;
    protected DataMap dataMap;

    public LockingUpdateController(ProjectController parent, DataMap dataMap) {
        super(parent);
        this.dataMap = dataMap;
    }

    public void startup() {
        this.view = new LockingUpdateDialog();
        boolean on = this.dataMap.getDefaultLockType() == 1;
        this.view.setTitle(on ? "Enable Optimistic Locking" : "Disable Optimistic Locking");
        this.initBindings();
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.show();
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getUpdateButton(), "updateAction()");
    }

    public void cancelAction() {
        if (this.view != null) {
            this.view.dispose();
        }
    }

    public void updateAction() {
        int defaultLockType = this.dataMap.getDefaultLockType();
        boolean on = defaultLockType == 1;
        boolean updateEntities = this.view.getEntities().isSelected();
        boolean updateAttributes = this.view.getAttributes().isSelected();
        boolean updateRelationships = this.view.getRelationships().isSelected();
        ProjectController parent = (ProjectController)this.getParent();
        for (ObjEntity entity : this.dataMap.getObjEntities()) {
            if (updateEntities && defaultLockType != entity.getDeclaredLockType()) {
                entity.setDeclaredLockType(defaultLockType);
                parent.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity));
            }
            if (updateAttributes) {
                for (ObjAttribute a : entity.getAttributes()) {
                    if (a.isUsedForLocking() == on) continue;
                    a.setUsedForLocking(on);
                    parent.fireObjAttributeEvent(new AttributeEvent((Object)this, (Attribute)a, (Entity)entity));
                }
            }
            if (!updateRelationships) continue;
            for (ObjRelationship r : entity.getRelationships()) {
                if (r.isUsedForLocking() == on) continue;
                r.setUsedForLocking(on);
                parent.fireObjRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)r, (Entity)entity));
            }
        }
        if (this.view != null) {
            this.view.dispose();
        }
    }
}

