/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.cayenne.modeler.dialog.pref.DBConnectionInfoEditor;
import org.apache.cayenne.modeler.util.CayenneController;

public class DataSourceWizardView
extends JDialog {
    protected JComboBox dataSources = new JComboBox();
    protected JButton configButton = new JButton("...");
    protected JButton okButton;
    protected JButton cancelButton;
    protected DBConnectionInfoEditor connectionInfo;

    public DataSourceWizardView(CayenneController controller) {
        this.configButton.setToolTipText("configure local DataSource");
        this.okButton = new JButton("Continue");
        this.cancelButton = new JButton("Cancel");
        this.connectionInfo = new DBConnectionInfoEditor(controller);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("20dlu:grow, pref, 3dlu, fill:max(50dlu;pref), 3dlu, fill:20dlu", "p"));
        builder.setDefaultDialogBorder();
        builder.addLabel("Saved DataSources:", cc.xy(2, 1));
        builder.add((Component)this.dataSources, cc.xy(4, 1));
        builder.add((Component)this.configButton, cc.xy(6, 1));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "North");
        this.getContentPane().add(this.connectionInfo.getView(), "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setTitle("DB Connection Info");
    }

    public JComboBox getDataSources() {
        return this.dataSources;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getConfigButton() {
        return this.configButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public DBConnectionInfoEditor getConnectionInfo() {
        return this.connectionInfo;
    }
}

