/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.objentity.ClassNameUpdaterView;
import org.apache.cayenne.modeler.util.CayenneController;

public class ClassNameUpdater
extends CayenneController {
    protected ClassNameUpdaterView view;
    protected ObjEntity entity;
    protected boolean updatePerformed;

    public ClassNameUpdater(CayenneController parent, ObjEntity entity) {
        super(parent);
        this.entity = entity;
    }

    public boolean doNameUpdate() {
        this.view = null;
        this.updatePerformed = false;
        boolean askForServerUpdate = true;
        boolean askForClientUpdate = true;
        String oldServerName = this.entity.getClassName();
        String suggestedServerName = this.suggestedServerClassName();
        if (oldServerName == null || oldServerName.length() == 0) {
            askForServerUpdate = false;
        } else if (suggestedServerName == null || suggestedServerName.equals(oldServerName)) {
            askForServerUpdate = false;
        } else if (oldServerName.contains("UntitledObjEntity")) {
            this.entity.setClassName(suggestedServerName);
            this.updatePerformed = true;
            askForServerUpdate = false;
        }
        String suggestedClientName = this.suggestedClientClassName();
        String oldClientName = this.entity.getClientClassName();
        if (suggestedClientName == null || suggestedClientName.equals(oldClientName)) {
            askForClientUpdate = false;
        } else if (oldClientName == null || oldClientName.length() == 0 || oldClientName.contains("UntitledObjEntity")) {
            this.entity.setClientClassName(suggestedClientName);
            this.updatePerformed = true;
            askForClientUpdate = false;
        }
        if (askForClientUpdate || askForServerUpdate) {
            this.view = new ClassNameUpdaterView();
            if (askForServerUpdate) {
                this.view.getServerClass().setVisible(true);
                this.view.getServerClass().setSelected(true);
                this.view.getServerClass().setText("Change Class Name to '" + suggestedServerName + "'");
            }
            if (askForClientUpdate) {
                this.view.getClientClass().setVisible(true);
                this.view.getClientClass().setSelected(true);
                this.view.getClientClass().setText("Change Client Class Name to '" + suggestedClientName + "'");
            }
            this.initBindings(suggestedServerName, suggestedClientName);
            this.view.pack();
            this.view.setModal(true);
            this.centerView();
            this.makeCloseableOnEscape();
            this.view.show();
        }
        return this.updatePerformed;
    }

    private String suggestedServerClassName() {
        String pkg = this.entity.getDataMap() != null ? this.entity.getDataMap().getDefaultPackage() : null;
        return this.suggestedClassName(this.entity.getName(), pkg, this.entity.getClassName());
    }

    private String suggestedClientClassName() {
        if (!this.entity.isClientAllowed()) {
            return null;
        }
        String pkg = this.entity.getDataMap() != null ? this.entity.getDataMap().getDefaultClientPackage() : null;
        return this.suggestedClassName(this.entity.getName(), pkg, this.entity.getClientClassName());
    }

    private String suggestedClassName(String entityName, String suggestedPackage, String oldClassName) {
        if (entityName == null || entityName.trim().length() == 0) {
            return null;
        }
        String pkg = suggestedPackage;
        if (oldClassName != null && oldClassName.lastIndexOf(46) > 0) {
            pkg = oldClassName.substring(0, oldClassName.lastIndexOf(46));
        }
        pkg = pkg == null ? "" : pkg + '.';
        int dot = entityName.lastIndexOf(46);
        if (dot >= 0 && dot < entityName.length() - 1) {
            entityName = entityName.substring(dot + 1);
        }
        return pkg + entityName;
    }

    protected void initBindings(final String suggestedServerName, final String suggestedClientName) {
        this.view.getUpdateButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassNameUpdater.this.view.getClientClass().isSelected()) {
                    ClassNameUpdater.this.entity.setClientClassName(suggestedClientName);
                    ClassNameUpdater.this.updatePerformed = true;
                }
                if (ClassNameUpdater.this.view.getServerClass().isSelected()) {
                    ClassNameUpdater.this.entity.setClassName(suggestedServerName);
                    ClassNameUpdater.this.updatePerformed = true;
                }
                ClassNameUpdater.this.view.dispose();
            }
        });
        this.view.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassNameUpdater.this.view.dispose();
            }
        });
    }

    public Component getView() {
        return this.view;
    }
}

