/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.dialog.objentity.EntityRelationshipsModel;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.IntIndexSelector;
import org.scopemvc.core.ModelChangeEvent;
import org.scopemvc.core.ModelChangeListener;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;
import org.scopemvc.model.collection.ListModel;

public class ObjRelationshipInfoModel
extends BasicModel {
    static final String COLLECTION_TYPE_MAP = "java.util.Map";
    static final String DEFAULT_MAP_KEY = "ID (default)";
    public static final Selector DB_RELATIONSHIP_PATH_SELECTOR = Selector.fromString((String)"dbRelationshipPath");
    public static final Selector SOURCE_ENTITY_NAME_SELECTOR = Selector.fromString((String)"relationship.sourceEntity.name");
    public static final Selector SELECTED_PATH_COMPONENT_SELECTOR = Selector.fromString((String)"selectedPathComponent");
    public static final Selector OBJECT_TARGET_SELECTOR = Selector.fromString((String)"objectTarget");
    public static final Selector OBJECT_TARGETS_SELECTOR = Selector.fromString((String)"objectTargets");
    public static final Selector RELATIONSHIP_NAME_SELECTOR = Selector.fromString((String)"relationshipName");
    public static final Selector TARGET_COLLECTIONS_SELECTOR = Selector.fromString((String)"targetCollections");
    public static final Selector TARGET_COLLECTION_SELECTOR = Selector.fromString((String)"targetCollection");
    public static final Selector MAP_KEYS_SELECTOR = Selector.fromString((String)"mapKeys");
    public static final Selector MAP_KEY_SELECTOR = Selector.fromString((String)"mapKey");
    protected ObjRelationship relationship;
    protected ListModel dbRelationshipPath;
    protected EntityRelationshipsModel selectedPathComponent;
    protected ObjEntity objectTarget;
    protected List objectTargets;
    protected List targetCollections;
    protected List mapKeys;
    protected String relationshipName;
    protected String targetCollection;
    protected String mapKey;

    public ObjRelationshipInfoModel(ObjRelationship relationship, Collection objEntities) {
        this.relationship = relationship;
        this.relationshipName = relationship.getName();
        this.objectTarget = (ObjEntity)relationship.getTargetEntity();
        this.mapKey = relationship.getMapKey();
        this.targetCollection = relationship.getCollectionType();
        if (this.targetCollection == null) {
            this.targetCollection = "java.util.List";
        }
        this.objectTargets = new ArrayList(objEntities.size());
        for (ObjEntity entity : objEntities) {
            if (entity.getDbEntity() == null) continue;
            this.objectTargets.add(entity);
        }
        Collections.sort(this.objectTargets, Comparators.getNamedObjectComparator());
        this.validateCanMap();
        this.targetCollections = new ArrayList(4);
        this.targetCollections.add("java.util.Collection");
        this.targetCollections.add("java.util.List");
        this.targetCollections.add(COLLECTION_TYPE_MAP);
        this.targetCollections.add("java.util.Set");
        this.mapKeys = new ArrayList();
        this.initMapKeys();
        this.dbRelationshipPath = new ListModel();
        for (DbRelationship dbRelationship : relationship.getDbRelationships()) {
            this.dbRelationshipPath.add((Object)new EntityRelationshipsModel((Relationship)dbRelationship));
        }
        this.fireModelChange(0, DB_RELATIONSHIP_PATH_SELECTOR);
        this.connectEnds();
        this.dbRelationshipPath.addModelChangeListener((ModelChangeListener)this);
    }

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public ListModel getDbRelationshipPath() {
        return this.dbRelationshipPath;
    }

    public EntityRelationshipsModel getSelectedPathComponent() {
        return this.selectedPathComponent;
    }

    public void setSelectedPathComponent(EntityRelationshipsModel selectedPathComponent) {
        if (this.selectedPathComponent != selectedPathComponent) {
            this.unlistenOldSubmodel(SELECTED_PATH_COMPONENT_SELECTOR);
            this.selectedPathComponent = selectedPathComponent;
            this.listenNewSubmodel(SELECTED_PATH_COMPONENT_SELECTOR);
            this.fireModelChange(0, SELECTED_PATH_COMPONENT_SELECTOR);
        }
    }

    public ObjEntity getObjectTarget() {
        return this.objectTarget;
    }

    public void setObjectTarget(ObjEntity objectTarget) {
        if (this.objectTarget != objectTarget) {
            this.unlistenOldSubmodel(OBJECT_TARGET_SELECTOR);
            this.objectTarget = objectTarget;
            this.listenNewSubmodel(OBJECT_TARGET_SELECTOR);
            this.fireModelChange(0, OBJECT_TARGET_SELECTOR);
            this.breakChain(-1);
            this.connectEnds();
            this.fireModelChange(0, DB_RELATIONSHIP_PATH_SELECTOR);
            this.initMapKeys();
        }
    }

    private void initMapKeys() {
        this.mapKeys.clear();
        this.mapKeys.add(DEFAULT_MAP_KEY);
        for (ObjAttribute attribute : this.objectTarget.getAttributes()) {
            this.mapKeys.add(attribute.getName());
        }
        this.fireModelChange(0, MAP_KEYS_SELECTOR);
        if (this.mapKey != null && !this.mapKeys.contains(this.mapKey)) {
            this.mapKey = DEFAULT_MAP_KEY;
            this.fireModelChange(0, MAP_KEY_SELECTOR);
        }
    }

    public List getObjectTargets() {
        return this.objectTargets;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public void setRelationshipName(String relationshipName) {
        this.relationshipName = relationshipName;
    }

    public void modelChanged(ModelChangeEvent event) {
        for (Selector selector = event.getSelector(); selector != null; selector = selector.getNext()) {
            if (!(selector instanceof IntIndexSelector)) continue;
            IntIndexSelector indexSel = (IntIndexSelector)selector;
            this.relationshipChanged(indexSel.getIndex());
            break;
        }
        super.modelChanged(event);
    }

    public synchronized void relationshipChanged(int index) {
        this.breakChain(index);
        this.connectEnds();
        this.dbRelationshipPath.fireModelChange(0, null);
    }

    public boolean isToMany() {
        for (EntityRelationshipsModel next : this.dbRelationshipPath) {
            Relationship relationship = next.getSelectedRelationship();
            if (relationship == null || !relationship.isToMany()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean savePath() {
        String mapKey;
        String collectionType;
        List oldPath;
        boolean hasChanges = false;
        if (!Util.nullSafeEquals((Object)this.relationship.getName(), (Object)this.relationshipName)) {
            hasChanges = true;
            this.relationship.setName(this.relationshipName);
        }
        if (!Util.nullSafeEquals((Object)this.objectTarget.getName(), (Object)this.relationship.getTargetEntityName())) {
            hasChanges = true;
            this.relationship.setTargetEntity((Entity)this.objectTarget);
        }
        if ((oldPath = this.relationship.getDbRelationships()).size() != this.dbRelationshipPath.size()) {
            hasChanges = true;
            this.updatePath();
        } else {
            for (int i = 0; i < oldPath.size(); ++i) {
                EntityRelationshipsModel next = (EntityRelationshipsModel)((Object)this.dbRelationshipPath.get(i));
                if (oldPath.get(i) == next.getSelectedRelationship()) continue;
                hasChanges = true;
                this.updatePath();
                break;
            }
        }
        String string = collectionType = "java.util.List".equals(this.targetCollection) || !this.relationship.isToMany() ? null : this.targetCollection;
        if (!Util.nullSafeEquals((Object)collectionType, (Object)this.relationship.getCollectionType())) {
            hasChanges = true;
            this.relationship.setCollectionType(collectionType);
        }
        String string2 = mapKey = COLLECTION_TYPE_MAP.equals(collectionType) && !DEFAULT_MAP_KEY.equals(this.mapKey) ? this.mapKey : null;
        if (!Util.nullSafeEquals((Object)mapKey, (Object)this.relationship.getMapKey())) {
            hasChanges = true;
            this.relationship.setMapKey(mapKey);
        }
        return hasChanges;
    }

    private void updatePath() {
        EntityRelationshipsModel next;
        Relationship nextPathComponent;
        this.relationship.clearDbRelationships();
        Iterator it = this.dbRelationshipPath.iterator();
        while (it.hasNext() && (nextPathComponent = (next = (EntityRelationshipsModel)((Object)it.next())).getSelectedRelationship()) != null) {
            this.relationship.addDbRelationship((DbRelationship)nextPathComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakChain(int index) {
        this.dbRelationshipPath.makeActive(false);
        try {
            while (this.dbRelationshipPath.size() > index + 1) {
                this.dbRelationshipPath.remove(this.dbRelationshipPath.size() - 1);
            }
        }
        finally {
            this.dbRelationshipPath.makeActive(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectEnds() {
        Relationship last = null;
        int size = this.dbRelationshipPath.size();
        if (size > 0) {
            EntityRelationshipsModel wrapper = (EntityRelationshipsModel)((Object)this.dbRelationshipPath.get(size - 1));
            last = wrapper.getSelectedRelationship();
        }
        DbEntity target = this.getEndEntity();
        if (last == null || last.getTargetEntity() != target) {
            DbEntity source;
            Object object = source = last == null ? this.getStartEntity() : last.getTargetEntity();
            if (source != null) {
                Relationship anyConnector = source != null ? source.getAnyRelationship((Entity)target) : null;
                EntityRelationshipsModel connector = null;
                connector = anyConnector == null ? new EntityRelationshipsModel((Entity)source, (Entity)this.getEndEntity()) : new EntityRelationshipsModel(anyConnector);
                this.dbRelationshipPath.makeActive(false);
                try {
                    this.dbRelationshipPath.add((Object)connector);
                }
                finally {
                    this.dbRelationshipPath.makeActive(true);
                }
            }
        }
    }

    private void validateCanMap() {
        if (this.relationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without source entity.");
        }
        if (this.relationship.getTargetEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without target entity.");
        }
        if (this.getStartEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without source DbEntity.");
        }
        if (this.getEndEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without target DbEntity.");
        }
    }

    public DbEntity getStartEntity() {
        return ((ObjEntity)this.relationship.getSourceEntity()).getDbEntity();
    }

    public DbEntity getEndEntity() {
        return this.objectTarget.getDbEntity();
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public String getTargetCollection() {
        return this.targetCollection;
    }

    public void setTargetCollection(String targetCollection) {
        this.targetCollection = targetCollection;
    }

    public List getMapKeys() {
        return this.mapKeys;
    }

    public List getTargetCollections() {
        return this.targetCollections;
    }
}

