/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.dialog.pref.TemplateCreator;
import org.apache.cayenne.modeler.dialog.pref.TemplatePreferencesView;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.TableBindingBuilder;

public class TemplatePreferences
extends CayenneController {
    protected TemplatePreferencesView view = new TemplatePreferencesView();
    protected PreferenceEditor editor;
    protected List templateEntries;
    protected ObjectBinding tableBinding;

    public TemplatePreferences(PreferenceDialog parent) {
        super(parent);
        this.editor = parent.getEditor();
        this.templateEntries = new ArrayList(this.getTemplateDomain().getDetails(FSPath.class));
        this.initBindings();
    }

    public Component getView() {
        return this.view;
    }

    protected Domain getTemplateDomain() {
        Domain domain = CodeTemplateManager.getTemplateDomain(this.getApplication());
        return this.editor.editableInstance(domain);
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getAddButton(), "addTemplateAction()");
        builder.bindToAction(this.view.getRemoveButton(), "removeTemplateAction()");
        TableBindingBuilder tableBuilder = new TableBindingBuilder(builder);
        tableBuilder.addColumn("Name", "#item.key", String.class, false, "XXXXXXXXXXXXXXX");
        tableBuilder.addColumn("Path", "#item.path", String.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableBuilder.bindToTable(this.view.getTable(), "templateEntries").updateView();
    }

    public List getTemplateEntries() {
        return this.templateEntries;
    }

    public PreferenceEditor getEditor() {
        return this.editor;
    }

    public void addTemplateAction() {
        FSPath path = new TemplateCreator(this).startupAction();
        if (path != null) {
            int len = this.templateEntries.size();
            this.templateEntries.add(path);
            ((AbstractTableModel)this.view.getTable().getModel()).fireTableRowsInserted(len, len);
        }
    }

    public void removeTemplateAction() {
        int selected = this.view.getTable().getSelectedRow();
        if (selected < 0) {
            return;
        }
        PreferenceDetail selection = (PreferenceDetail)((Object)this.templateEntries.remove(selected));
        this.editor.deleteDetail(this.getTemplateDomain(), selection.getKey());
        ((AbstractTableModel)this.view.getTable().getModel()).fireTableRowsDeleted(selected, selected);
    }
}

