/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.AbstractRemoveCallbackMethodAction;
import org.apache.cayenne.modeler.editor.CallbackDescriptorTableModel;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjRelationshipTableModel;
import org.apache.cayenne.modeler.editor.StringTransferHandler;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.event.CallbackMethodListener;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.PanelFactory;

public abstract class AbstractCallbackMethodsTab
extends JPanel {
    ProjectController mediator;
    protected JToolBar toolBar;
    protected CayenneTable table;
    protected JComboBox callbackTypeCombo = CayenneWidgetFactory.createComboBox(new Object[]{new CallbackType(LifecycleEvent.PRE_PERSIST, "pre-persist"), new CallbackType(LifecycleEvent.POST_PERSIST, "post-persist"), new CallbackType(LifecycleEvent.PRE_UPDATE, "pre-update"), new CallbackType(LifecycleEvent.POST_UPDATE, "post-update"), new CallbackType(LifecycleEvent.PRE_REMOVE, "pre-remove"), new CallbackType(LifecycleEvent.POST_REMOVE, "post-remove"), new CallbackType(LifecycleEvent.POST_LOAD, "post-load")}, false);

    public AbstractCallbackMethodsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    protected abstract CallbackMap getCallbackMap();

    protected void buildFilter(DefaultFormBuilder builder) {
        JLabel callbacktypeLabel = new JLabel("Callback type:");
        builder.append((Component)callbacktypeLabel, (Component)this.callbackTypeCombo);
    }

    protected CayenneAction getCreateCallbackMethodAction() {
        Application app = Application.getInstance();
        return app.getAction("Create callback method");
    }

    protected AbstractRemoveCallbackMethodAction getRemoveCallbackMethodAction() {
        Application app = Application.getInstance();
        return (AbstractRemoveCallbackMethodAction)app.getAction("Remove Callback Method");
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.toolBar.add(this.getCreateCallbackMethodAction().buildButton());
        this.toolBar.add(this.getRemoveCallbackMethodAction().buildButton());
        this.add((Component)this.toolBar, "North");
        JPanel auxPanel = new JPanel();
        auxPanel.setOpaque(false);
        auxPanel.setLayout(new BorderLayout());
        FormLayout formLayout = new FormLayout("right:70dlu, 3dlu, fill:150dlu");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout);
        this.buildFilter(builder);
        auxPanel.add((Component)builder.getPanel(), "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new StringRenderer());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDragEnabled(true);
        this.table.setTransferHandler(new StringTransferHandler(){

            protected String exportString(JComponent c) {
                JTable table = (JTable)c;
                int rowIndex = table.getSelectedRow();
                String result = null;
                if (rowIndex >= 0 && rowIndex < table.getModel().getRowCount()) {
                    result = String.valueOf(table.getModel().getValueAt(rowIndex, 0));
                }
                return result;
            }

            protected void importString(JComponent c, String callbackMethod) {
                JTable table = (JTable)c;
                int rowIndex = table.getSelectedRow();
                CallbackDescriptor callbackDescriptor = AbstractCallbackMethodsTab.this.getCallbackMap().getCallbackDescriptor(((CallbackType)AbstractCallbackMethodsTab.this.callbackTypeCombo.getSelectedItem()).getType());
                AbstractCallbackMethodsTab.this.mediator.setDirty(callbackDescriptor.moveMethod(callbackMethod, rowIndex));
                AbstractCallbackMethodsTab.this.rebuildTable();
            }

            protected void cleanup(JComponent c, boolean remove) {
            }
        });
        auxPanel.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
        this.add((Component)auxPanel, "Center");
    }

    protected void initController() {
        this.mediator.addCallbackMethodListener(new CallbackMethodListener(){

            public void callbackMethodChanged(CallbackMethodEvent e) {
                if (AbstractCallbackMethodsTab.this.isVisible()) {
                    AbstractCallbackMethodsTab.this.rebuildTable();
                }
            }

            public void callbackMethodAdded(CallbackMethodEvent e) {
                if (AbstractCallbackMethodsTab.this.isVisible()) {
                    AbstractCallbackMethodsTab.this.updateCallbackTypeCounters();
                    AbstractCallbackMethodsTab.this.rebuildTable();
                }
            }

            public void callbackMethodRemoved(CallbackMethodEvent e) {
                if (AbstractCallbackMethodsTab.this.isVisible()) {
                    AbstractCallbackMethodsTab.this.updateCallbackTypeCounters();
                    AbstractCallbackMethodsTab.this.rebuildTable();
                }
            }
        });
        this.callbackTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AbstractCallbackMethodsTab.this.mediator.setCurrentCallbackType((CallbackType)AbstractCallbackMethodsTab.this.callbackTypeCombo.getSelectedItem());
                    AbstractCallbackMethodsTab.this.updateCallbackTypeCounters();
                    AbstractCallbackMethodsTab.this.rebuildTable();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AbstractCallbackMethodsTab.this.mediator.setCurrentCallbackMethod(AbstractCallbackMethodsTab.this.table.getSelectedRow() >= 0 ? (String)AbstractCallbackMethodsTab.this.table.getModel().getValueAt(AbstractCallbackMethodsTab.this.table.getSelectedRow(), 0) : null);
                    AbstractCallbackMethodsTab.this.getRemoveCallbackMethodAction().setEnabled(AbstractCallbackMethodsTab.this.table.getSelectedRow() >= 0);
                }
            }
        });
    }

    protected void updateCallbackTypeCounters() {
        CallbackMap map = this.getCallbackMap();
        for (int i = 0; i < this.callbackTypeCombo.getItemCount(); ++i) {
            CallbackType type = (CallbackType)this.callbackTypeCombo.getItemAt(i);
            if (map == null) {
                type.setCounter(0);
                continue;
            }
            CallbackDescriptor callbackDescriptor = map.getCallbackDescriptor(type.getType());
            type.setCounter(callbackDescriptor.getCallbackMethods().size());
        }
        this.callbackTypeCombo.repaint();
    }

    protected void rebuildTable() {
        CallbackType callbackType = (CallbackType)this.callbackTypeCombo.getSelectedItem();
        ArrayList methods = new ArrayList();
        CallbackDescriptor descriptor = null;
        CallbackMap callbackMap = this.getCallbackMap();
        if (callbackMap != null && callbackType != null) {
            descriptor = callbackMap.getCallbackDescriptor(callbackType.getType());
            Iterator j = descriptor.getCallbackMethods().iterator();
            while (j.hasNext()) {
                methods.add(j.next());
            }
        }
        CallbackDescriptorTableModel model = new CallbackDescriptorTableModel(this.mediator, this, methods, descriptor);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn methodNameColumn = this.table.getColumnModel().getColumn(0);
        methodNameColumn.setMinWidth(424);
        this.mediator.setCurrentCallbackMethod(null);
    }

    protected final CallbackType getSelectedCallbackType() {
        CallbackType selectedType = (CallbackType)this.callbackTypeCombo.getSelectedItem();
        if (selectedType == null) {
            selectedType = (CallbackType)this.callbackTypeCombo.getItemAt(0);
        }
        return selectedType;
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int align = column == 2 ? 0 : 2;
            super.setHorizontalAlignment(align);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)table.getModel();
            ObjRelationship relationship = model.getRelationship(row);
            if (relationship != null && relationship.getSourceEntity() != model.getEntity()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            return this;
        }
    }
}

